#include "mbed.h"
#include "tsi_sensor.h"
#define ELEC0 9
#define ELEC1 10

/*MAQUINA DE ESTADOS*/
#define INICIO           0
#define ACCION           1
#define ESCRIBIR         2
#define LEER             3
#define ANALOG           4
#define DIGI             5
#define ELIJO_LED        6
#define VERIFICACION     7
#define LED_CAMBIAR      8
#define CORRECTO         9
#define FINAL            10
#define LEDS             11
#define DEC_DAC          12
#define U_DAC            13

//UART
RawSerial pc(USBTX, USBRX);

//Salida Digital
AnalogOut  DAC(PTE30);

//Entradas Analogicas
AnalogIn A_1(A0);

//Entradas Digitales
DigitalIn I0(D2);
DigitalIn I1(D3);

//Salidas digitales
DigitalOut Rojo(LED1);
DigitalOut Verde(LED2);
DigitalOut Azul(LED3);

//Funciones
void onCharReceived();


//Variables
char   c = '\0';    //Variable donde se guarda lo leido
bool newdata = false;   //Se pone en true cuando hay nuevos datos
char respuesta[] = "$RXXDVV!xx";    //Vector en donde guardo la info
char recibido[10]= {0};
float valorD = 0;
char DD = 48;
char UD = 48;
char aux=0;         //Variable para moverme en el vector "recibido"
int E = INICIO;     //Variable que guarda el estado
char indicador;     //Variable que guard variable que se lee / escribe
bool lr, lg, lb;    //Variable que guarda el estado de los LEDS
bool ledCambiar;    //Variable que guarda el cambio del LED despues de la verificacion
bool led;           //Variable que guarda dato LED despues de la verificacion
bool vuelta = 0;    //Variable que sirve para verificacion
float analogico;    //Variable que guarda dato analogico despues de la verificacion
char digital;       //Variable que guarda dato digital despues de la verificacion
int dato;           //Variable que guarda que dato se quiere leer despues de la verificacion
bool correcto = 0;
int verif, verifD, verifU;
int verifReal, verifRealC, verifRealD, verifRealU;
int analogicoC, analogicoD, analogicoU;

int main(void)
{
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    pc.attach(&onCharReceived);
    Rojo = 1;
    Verde = 1;
    Azul = 1;
    DAC = 0;
    while (true) {
        if(newdata) {
            newdata = false;
            aux++;
            recibido[aux]=c;
            switch(E) {

                case INICIO:
                    if(c == '$') {
                        E = ACCION;
                        aux = 0;
                    }
                    break;

                case ACCION:
                    recibido[0] = '$';
                    vuelta = 0;
                    aux = 1;
                    switch(c) {
                        default:
                            E = INICIO;
                            break;
                        case 'W':
                            E = ESCRIBIR;
                            break;
                        case 'R':
                            E = LEER;
                            break;
                        case '$':
                            break;
                    }
                    break;

                case ESCRIBIR:
                    switch(c) {
                        case 'L':
                            E = ELIJO_LED;
                            break;
                        case '$':
                            E = ACCION;
                            break;
                        default:
                            E = INICIO;
                            break;
                    }
                    break;

                case ELIJO_LED:
                    switch(c) {
                        case 'R':
                            indicador = 1;
                            E = LED_CAMBIAR;
                            break;
                        case 'G':
                            indicador = 2;
                            E = LED_CAMBIAR;
                            break;
                        case 'B':
                            indicador = 3;
                            E = LED_CAMBIAR;
                            break;
                        case 'D':
                            E = DEC_DAC;
                            break;
                        case '$':
                            E = ACCION;
                            break;
                        default:
                            E = INICIO;
                            break;
                    }
                    dato = 0;
                    break;
                case DEC_DAC:
                    if(c >= '0' && c <= '9') {
                        DD = c;
                        valorD = ((float)c - 48.0f) / 10.0f;
                        E = U_DAC;
                        break;
                    } else if(c == '$') {
                        E = ACCION;
                        break;
                    } else if(c == 'X') {
                        E = FINAL;
                        correcto = 1;
                        dato = 4;
                    }
                    else {
                        E = INICIO;
                        break;
                    }
                case U_DAC:
                    if(c >= '0' && c <= '9') {
                        valorD += ((float)c - 48.0f) / 100.0f;
                        DAC = valorD;
                        dato = 4;
                        UD = c;
                        E = FINAL;
                        break;
                    } else if(c == '$') {
                        E = ACCION;
                        break;
                    } else {
                        E = INICIO;
                        break;
                    }

                case LED_CAMBIAR:
                    switch(c) {
                        case '$':
                            E = ACCION;
                            break;
                        case '0':
                            ledCambiar = 1;
                            E = VERIFICACION;
                            break;
                        case '1':
                            ledCambiar = 0;
                            E = VERIFICACION;
                            break;
                        default:
                            E = INICIO;
                            break;
                    }
                    break;

                case LEER:
                    switch(c) {
                        case 'A':
                            E = ANALOG;
                            break;
                        case 'I':
                            E = DIGI;
                            break;
                        case 'L':
                            E = LEDS;
                            break;
                        case '$':
                            E = ACCION;
                            break;
                        default:
                            E = INICIO;
                            break;
                    }
                    break;
                    
                case LEDS:
                    switch(c) {
                        case 'R':
                            indicador = 1;
                            led = lr;
                            E = VERIFICACION;
                            break;
                        case 'G':
                            indicador = 2;
                            led = lg;
                            E = VERIFICACION;
                            break;
                        case 'B':
                            indicador = 3;
                            led = lb;
                            E = VERIFICACION;
                            break;
                        case '$':
                            E = ACCION;
                            break;
                        default:
                            E = INICIO;
                            break;
                    }
                    dato = 3;
                    break;

                case DIGI:
                    switch (c) {
                        case '0':
                            indicador = 0;
                            digital = I0;
                            E = VERIFICACION;
                            break;
                        case '1':
                            indicador = 1;
                            digital = I1;
                            E = VERIFICACION;
                            break;
                        case '$':
                            E = ACCION;
                            break;
                        default:
                            E = INICIO;
                            break;
                    }
                    dato = 2;
                    break;

                case ANALOG:
                    switch(c) {
                        case '0':
                            indicador = 0;
                            analogico = tsi.readPercentage() * 100;
                            E = VERIFICACION;
                            break;
                        case '1':
                            indicador = 1;
                            analogico = A_1 * 100;
                            E = VERIFICACION;
                            break;
                        case '$':
                            E = ACCION;
                            break;
                        default:
                            E = INICIO;
                            break;
                    }
                    dato = 1;
                    break;

                case VERIFICACION:
                    if (c == '$') {
                        E = ACCION;
                        break;
                    }
                    if(!vuelta) {
                        vuelta = 1;
                        if(recibido[1] == 'R') {
                            verifReal = recibido[1]^recibido[2]^recibido[3];
                        }
                        if(recibido[1] == 'W') {
                            verifReal = recibido[1]^recibido[2]^recibido[3]^recibido[4];
                        }
                    } else {
                        vuelta = 0;
                        if(recibido[1] == 'R') {
                            verif = (recibido[4] - 48) * 10 + (recibido[5] - 48);
                        }
                        if(recibido[1] == 'W') {
                            verif = (recibido[5] - 48) * 10 + (recibido[6] - 48);
                        }
                        verifRealC = verifReal / 100;
                        verifRealD = (verifReal - verifRealC * 100);
                        if(verif == verifRealD)
                            E = FINAL;
                        else {
                            //printf("   La verificacion correcta es:%d\r\n", verifReal);
                            E = INICIO;
                        }
                    }
                    break;

                case FINAL:
                    switch(c) {
                        case '$':
                            E = ACCION;
                            break;
                        case '!':
                            correcto = 1;
                            E = INICIO;
                            break;
                        default:
                            E = INICIO;
                            break;
                    }
                    break;
            }
        }
        if (correcto) {
            correcto = 0;
            recibido[aux+1]=0;
            aux = 0;
            switch(dato) {
                case 0:
                    switch(indicador) {
                        case 1:
                            Rojo = ledCambiar;
                            lr = ledCambiar;
                            break;
                        case 2:
                            Verde = ledCambiar;
                            lg = ledCambiar;
                            break;
                        case 3:
                            Azul = ledCambiar;
                            lb = ledCambiar;
                            break;
                    }
                    //printf("  Se actualizo el LED\r\n");
                    break;
                case 1:
                    analogicoC = analogico / 100;
                    analogicoD = (analogico - analogicoC * 100) / 10;
                    analogicoU = (analogico - analogicoC * 100 - analogicoD * 10);
                    respuesta[2] = 'A';
                    respuesta[3] = indicador + 48;
                    respuesta[4] = analogicoD + 48;
                    respuesta[5] = analogicoU + 48;
                    verifReal = respuesta[1]^respuesta[2]^respuesta[3]^respuesta[4]^respuesta[5];
                    verifRealC = verifReal / 100;
                    verifRealD = (verifReal - verifRealC * 100) / 10;
                    verifRealU = (verifReal - verifRealC * 100 - verifRealD * 10);
                    respuesta[6] = verifRealD + 48;
                    respuesta[7] = verifRealU + 48;
                    respuesta[8] = '!';
                    respuesta[9] = 0;
                    printf("%s\r\n",respuesta);
                    break;
                case 2:
                    respuesta[2] = 'I';
                    respuesta[3] = indicador + 48;
                    respuesta[4] = digital + 48;
                    verifReal = respuesta[1]^respuesta[2]^respuesta[3]^respuesta[4];
                    verifRealC = verifReal / 100;
                    verifRealD = (verifReal - verifRealC * 100) / 10;
                    verifRealU = (verifReal - verifRealC * 100 - verifRealD * 10);
                    respuesta[5] = verifRealD + 48;
                    respuesta[6] = verifRealU + 48;
                    respuesta[7] = verifRealU + 48;
                    respuesta[8] = '!';
                    respuesta[9] = 0;
                    printf("%s\r\n",respuesta);
                    break;
                case 3:
                    respuesta[2] = 'L';
                    switch(indicador) {
                        case 1:
                            respuesta[3] = 'R';
                            respuesta[4] = !Rojo + 48;
                            break;
                        case 2:
                            respuesta[3] = 'G';
                            respuesta[4] = !Verde + 48;
                            break;
                        case 3:
                            respuesta[3] = 'B';
                            respuesta[4] = !Azul + 48;
                            break;
                    }
                    verifReal = respuesta[1]^respuesta[2]^respuesta[3]^respuesta[4];
                    verifRealC = verifReal / 100;
                    verifRealD = (verifReal - verifRealC * 100) / 10;
                    verifRealU = (verifReal - verifRealC * 100 - verifRealD * 10);
                    respuesta[5] = verifRealD + 48;
                    respuesta[6] = verifRealU + 48;
                    respuesta[7] = verifRealU + 48;
                    respuesta[8] = '!';
                    respuesta[9] = 0;
                    printf("%s\r\n",respuesta);
                    break;
                case 4:
                    analogicoC = '0';
                    analogicoD = DD ;
                    analogicoU = UD;
                    respuesta[2] = 'L';
                    respuesta[3] = 'D';
                    respuesta[4] = analogicoD;
                    respuesta[5] = analogicoU;
                    verifReal = respuesta[1]^respuesta[2]^respuesta[3]^respuesta[4]^respuesta[5];
                    verifRealC = verifReal / 100;
                    verifRealD = (verifReal - verifRealC * 100) / 10;
                    verifRealU = (verifReal - verifRealC * 100 - verifRealD * 10);
                    respuesta[6] = verifRealD + 48;
                    respuesta[7] = verifRealU + 48;
                    respuesta[8] = '!';
                    respuesta[9] = 0;
                    printf("%s\r\n",respuesta);
                    break;
            }
        }
    }
}

void onCharReceived()
{
    c = pc.getc();
    newdata = true;
}