#include "mbed.h"                                   //Incluye todas las bibliotecas de C++ q se te ocurran mas algunas funciones de mbed
#include "tsi_sensor.h"                             //Headers tsi
#include "MMA8451Q.h"                               //Headers acelerometro

#define ELEC0 9                                     //Electrodos TSI
#define ELEC1 10

PinName const SDA = PTE25;                          //Config I2C Acelerometro (NO USAR ESTAS PATAS PARA OTRAS COSAS)
PinName const SCL = PTE24;

//Timer
Ticker ticker;

//UART
RawSerial pc(USBTX, USBRX);                         //La placa usa las patas q en el pinout figuran como UART0. NO USAR ESTAS PATAS PARA OTRAS COSAS.

//ADC
AnalogIn nombre_entrada_analogica (/*Pata uC*/);    //Entrada Analogica entre 0v y 3.3v. Te tira un valor proporcional entre 0 y 1

//PWM
PwmOut nombre_salida_pwm(/*Pata uC*/);


//DAC
AnalogOut nombre_salida_analogica(/*Pata uC*/);

//GPIO
DigitalIn nombre_entrada_digital(/*Pata uC*/);
DigitalOut nombre_salida_digital(/*Pata uC*/);
DigitalOut lr(LED_RED);                             //Para usar LEDs de la placa (los podes usar con la salida PWM o la analogica tambien)
DigitalOut lg(LED_GREEN);                           //0: PRENDIDO
DigitalOut lb(LED_BLUE);                            //1: APAGADO

//Funciones q usas como interrupts    
void interrupcion_UART();
void interrupcion_timer();

int milisegundos;                                   //Cuenta milisegundos
char caracter;                                      //Memoria caracter recibido por Uart

int main(void) {
    //Timer
    ticker.attach(&interrupcion_timer,0.001)        //Se llama la funcion "timer" cada 0.001 seg (interrupt)    
    
    //UART
    pc.attach(&interrupcion_UART);                  //Se llama la funcion interrupcion_UART cada vez q recibis algo (interrupt)
    
    //TSI (Slider)
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);          //Config TSI (Slider)
    
    //Acelerómetro
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);    //Config acelerómetro           
    
    double valor_tsi;
    double valor_acelerometro_eje_x;
    double valor_acelerometro_eje_Y;
    double valor_acelerometro_eje_Z;
    
    while (true) {
        valor_tsi = tsi.readPercentage();           //Lees valor entre 0 y 1 (proporcional a posicion)
        
        //Valores ejes acelerometro. Creo q puede ir entre -1 y 1 (probar)
        valor_acelerometro_eje_x = acc.getAccX();   //Eje X
        valor_acelerometro_eje_Y = acc.getAccY();   //Eje Y
        valor_acelerometro_eje_Z = acc.getAccZ();   //Eje Z
        nombre_saida_analogica = 0.5;
        if(nombre_entrada_analogica<0.6)
            nombre_salida_digital = true;
        else
            nombre_salida_digital = false;    
        if(valor_acelerometro_eje_x<0.8) {
            nombre_salida_pwm =  0.1;               //Cambias PWM a 0.1% de duty
            nombre_salida_pwm.period(1);            //Cambias periodo a 10 seg
        }
        nombre_salida_analogica = 0.6;
        printf("PARA MANDARLE ALGO A LA PC USAR PRINTF\r\n);
        printf("No olvidarse de poner al final \r\n xq es una poronga q se traba todo\r\n");
    }
}

void interrupcion_timer() {
    milisegundos++;
}

void interrupcion_UART() {
    caracter = pc.getc();                           //Guardas el byte recibido (caracter ASCII)
}