// uLCD-144-G2 demo program for uLCD-4GL LCD driver library
//
#include "mbed.h"
#include "uLCD_4DGL.h"
#include <math.h>
#include <cmath>
#include <bitset>
#include "PinDetect.h"
#include <cmath>
#include <string>

PinDetect pb1(p18);
PinDetect pb2(p17);
PinDetect pb3(p16);
PinDetect pb4(p15);
PinDetect pb5(p23);
PinDetect pb6(p24);
DigitalOut myled(LED1);
DigitalOut myled1(LED2);
DigitalOut myled2(LED3);
DigitalOut myled3(LED4);
uLCD_4DGL uLCD(p28,p27,p30);
DigitalIn dip1(p20);
DigitalIn dip2(p19);
DigitalIn dip3(p21);
DigitalIn dip4(p22);
DigitalIn dip5(p10);
DigitalIn dip6(p11);
DigitalIn dip7(p12);
DigitalIn dip8(p13);
Serial pc(USBTX, USBRX); // tx, rx

int d1;
int d2;
int d3;
int d4;
int out;
void pb1_hit_callback (void) {
    bitset<4> foo;
    bitset<4> bar;
    bitset<4> result;
    for(int i = 0; i < 4;i++){
          if(i == 0){
            foo.set(i,dip1); 
          }else if(i == 1){
            foo.set(i,dip2); 
          }else if(i == 2){
            foo.set(i,dip3); 
          }else if(i == 3){
            foo.set(i,dip4); 
          }
       }
       for(int i = 0; i < 4;i++){
          if(i == 0){
            bar.set(i,dip5); 
          }else if(i == 1){
            bar.set(i,dip6); 
          }else if(i == 2){
            bar.set(i,dip7); 
          }else if(i == 3){
            bar.set(i,dip8); 
          }
       }
    uLCD.cls();
    uLCD.locate(0,0);
    string fook = foo.to_string<char,string::traits_type,string::allocator_type>();
    string book = bar.to_string<char,string::traits_type,string::allocator_type>();
    result = foo&=bar;
    string rook = result.to_string<char,string::traits_type,string::allocator_type>();
    uLCD.printf("Calculation\n");
    uLCD.printf("%s AND %s\n\n",fook.c_str(),book.c_str());
    uLCD.printf("Result\n");
    uLCD.printf("%s",rook.c_str());
    //uLCD.printf("%d & %d - %d",foo.to_ulong(),bar.to_ulong(),result);
}

void pb2_hit_callback (void) {
    bitset<4> foo;
    bitset<4> bar;
    bitset<4> result;
    for(int i = 0; i < 4;i++){
          if(i == 0){
            foo.set(i,dip1); 
          }else if(i == 1){
            foo.set(i,dip2); 
          }else if(i == 2){
            foo.set(i,dip3); 
          }else if(i == 3){
            foo.set(i,dip4); 
          }
       }
       for(int i = 0; i < 4;i++){
          if(i == 0){
            bar.set(i,dip5); 
          }else if(i == 1){
            bar.set(i,dip6); 
          }else if(i == 2){
            bar.set(i,dip7); 
          }else if(i == 3){
            bar.set(i,dip8); 
          }
       }
    uLCD.cls();
    uLCD.locate(0,0);
    string fook = foo.to_string<char,string::traits_type,string::allocator_type>();
    string book = bar.to_string<char,string::traits_type,string::allocator_type>();
    result = foo|=bar;
    string rook = result.to_string<char,string::traits_type,string::allocator_type>();
    uLCD.printf("Calculation\n");
    uLCD.printf("%s OR %s\n\n",fook.c_str(),book.c_str());
    uLCD.printf("Result\n");
    uLCD.printf("%s",rook.c_str());
}

void pb3_hit_callback (void) {
    bitset<4> foo;
    bitset<4> bar;
    bitset<4> result;
    for(int i = 0; i < 4;i++){
          if(i == 0){
            foo.set(i,dip1); 
          }else if(i == 1){
            foo.set(i,dip2); 
          }else if(i == 2){
            foo.set(i,dip3); 
          }else if(i == 3){
            foo.set(i,dip4); 
          }
       }
       for(int i = 0; i < 4;i++){
          if(i == 0){
            bar.set(i,dip5); 
          }else if(i == 1){
            bar.set(i,dip6); 
          }else if(i == 2){
            bar.set(i,dip7); 
          }else if(i == 3){
            bar.set(i,dip8); 
          }
       }
    uLCD.cls();
    uLCD.locate(0,0);
    string fook = foo.to_string<char,string::traits_type,string::allocator_type>();
    string book = bar.to_string<char,string::traits_type,string::allocator_type>();
    result = foo|=bar;
    result = result.flip();
    string rook = result.to_string<char,string::traits_type,string::allocator_type>();
    uLCD.printf("Calculation\n");
    uLCD.printf("%s NOR %s\n\n",fook.c_str(),book.c_str());
    uLCD.printf("Result\n");
    uLCD.printf("%s",rook.c_str());
    //uLCD.printf("%d",result.to_ulong());
}

void pb4_hit_callback (void) {
    bitset<4> foo;
    bitset<4> bar;
    bitset<4> result;
    for(int i = 0; i < 4;i++){
          if(i == 0){
            foo.set(i,dip1); 
          }else if(i == 1){
            foo.set(i,dip2); 
          }else if(i == 2){
            foo.set(i,dip3); 
          }else if(i == 3){
            foo.set(i,dip4); 
          }
       }
       for(int i = 0; i < 4;i++){
          if(i == 0){
            bar.set(i,dip5); 
          }else if(i == 1){
            bar.set(i,dip6); 
          }else if(i == 2){
            bar.set(i,dip7); 
          }else if(i == 3){
            bar.set(i,dip8); 
          }
       }
    uLCD.cls();
    uLCD.locate(0,0);
    string fook = foo.to_string<char,string::traits_type,string::allocator_type>();
    string book = bar.to_string<char,string::traits_type,string::allocator_type>();
    result = foo&=bar;
    result = result.flip(); 
    string rook = result.to_string<char,string::traits_type,string::allocator_type>();
    uLCD.printf("Calculation\n");
    uLCD.printf("%s NAND %s\n\n",fook.c_str(),book.c_str());
    uLCD.printf("Result\n");
    uLCD.printf("%s",rook.c_str());
}

void pb5_hit_callback (void) {
    bitset<4> foo;
    bitset<4> bar;
    bitset<4> result;
    for(int i = 0; i < 4;i++){
          if(i == 0){
            foo.set(i,dip1); 
          }else if(i == 1){
            foo.set(i,dip2); 
          }else if(i == 2){
            foo.set(i,dip3); 
          }else if(i == 3){
            foo.set(i,dip4); 
          }
       }
       for(int i = 0; i < 4;i++){
          if(i == 0){
            bar.set(i,dip5); 
          }else if(i == 1){
            bar.set(i,dip6); 
          }else if(i == 2){
            bar.set(i,dip7); 
          }else if(i == 3){
            bar.set(i,dip8); 
          }
       }
    uLCD.cls();
    uLCD.locate(0,0);
    int n1 = (int) foo.to_ulong();
    int n2 = (int) bar.to_ulong();
    string fook = foo.to_string<char,string::traits_type,string::allocator_type>();
    string book = bar.to_string<char,string::traits_type,string::allocator_type>();
    uLCD.printf("Calculation\n");
    uLCD.printf("%s + %s\n\n",fook.c_str(),book.c_str());
    uLCD.printf("Result\n");
    bitset<8>      res(n1+n2);
    string rook = res.to_string<char,string::traits_type,string::allocator_type>();
    uLCD.printf("%s",rook.c_str());
    
}

void pb6_hit_callback (void) {
    bitset<4> foo;
    bitset<4> bar;
    bitset<4> result;
    for(int i = 0; i < 4;i++){
          if(i == 0){
            foo.set(i,dip1); 
          }else if(i == 1){
            foo.set(i,dip2); 
          }else if(i == 2){
            foo.set(i,dip3); 
          }else if(i == 3){
            foo.set(i,dip4); 
          }
       }
       for(int i = 0; i < 4;i++){
          if(i == 0){
            bar.set(i,dip5); 
          }else if(i == 1){
            bar.set(i,dip6); 
          }else if(i == 2){
            bar.set(i,dip7); 
          }else if(i == 3){
            bar.set(i,dip8); 
          }
       }
    uLCD.cls();
    uLCD.locate(0,0);
    int n1 = (int) foo.to_ulong();
    int n2 = (int) bar.to_ulong();
    string fook = foo.to_string<char,string::traits_type,string::allocator_type>();
    string book = bar.to_string<char,string::traits_type,string::allocator_type>();
    string rook = result.to_string<char,string::traits_type,string::allocator_type>();
    uLCD.printf("Calculation\n");
    uLCD.printf("%s - %s\n\n",fook.c_str(),book.c_str());
    uLCD.printf("Result\n");
    //bitset<8>      res(abs (n1-n2));
    //string rok = res.to_string<char,string::traits_type,string::allocator_type>();
    uLCD.printf("%d",abs (n1-n2));
    
}

int main()
{
    dip1.mode(PullUp);
    dip2.mode(PullUp);
    dip3.mode(PullUp);
    dip4.mode(PullUp);
    dip5.mode(PullUp);
    dip6.mode(PullUp);
    dip7.mode(PullUp);
    dip8.mode(PullUp);
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    pb1.attach_deasserted(&pb1_hit_callback);
    // Start sampling pb input using interrupts
    pb1.setSampleFrequency();
    pb2.attach_deasserted(&pb2_hit_callback);
    pb2.setSampleFrequency();
    pb3.attach_deasserted(&pb3_hit_callback);
    pb3.setSampleFrequency();
    pb4.attach_deasserted(&pb4_hit_callback);
    pb4.setSampleFrequency();
    pb5.attach_deasserted(&pb5_hit_callback);
    pb5.setSampleFrequency();
    pb6.attach_deasserted(&pb6_hit_callback);
    pb6.setSampleFrequency();
    wait(1);
    while(1) {
       
       
       
       
   }

}
