/* measure.cpp verion 1.0 */
/* wajw  25/08/15  */

/* Prog to measure period of rotation of flywheel */
/* and display value on the Application Board LCD */
/* Generates interrupt on +ve edge of CAP2.0 (mbed pin 30) and display capture regt */
/* ISR Stores captured Timer2 value as 'period', resets Timer 2 and sets flag */

/* For test purposes, a Ticker is producing pulses on pin 29,*/
/* and these can be used to drive CAP2.0 on pin 30 */
/* Ticker also drives LED1 which switches after 10 pulses as health check */

/* To use the Ticker - need to join pins 29 and 30 */


#include "mbed.h"
#include "C12832_lcd.h"

//Global Variables:

volatile int count = 0, period = 0;
volatile int pflag = 0, sflag = 0;
C12832_LCD lcd;

// Function Prototypes:

void led_switch(void);  
void Tick1_isr (void);
void Timer2_isr (void);
void Timer2_init (void);

// Diagnostic Features:

Ticker Tick; //Tick produces a periodic interrupt
DigitalOut myled(LED1); //myled is diagnostic O/P driven by Ticker
DigitalOut displed(LED2); //displed is diagnostic O/P driven by Timer2_isr()
DigitalOut pulse(p29); //Pulse output for testing measure software

//Function Declarations:

void led_switch() 
// Function which Toggles LED1 
{ 
    myled=!myled;
}

void Timer2_init()
{
// Connect pin 30 to CAP2.0:

   LPC_PINCON->PINSEL0 |= (0x3<<8);    // Bits 9,8 = 1,1 = pin function CAP2.0 (p30)

//Configure Timer 2:

   LPC_SC->PCONP |= (0x01 << 22); // Enable Timer 2
   LPC_SC->PCLKSEL1 |= (0x01 << 12) ; //Timer2 to use CCLK
   LPC_TIM2->PR = 9600 - 1; //Set Timer2 prescale 
   LPC_TIM2->TCR |= (0x01); //Enable Timer2
   LPC_TIM2->CTCR |= (0x00); // Timer2 in timer mode
   LPC_TIM2->TC = (0x00); //Initialise Timer2  
   
//Configure Capture input mode:

   LPC_TIM2->CCR |= (0x01);  //Capture on +ve edge of CAP2.0
   LPC_TIM2->CCR |= (0x01 << 2);  //Generate Interrupt on +ve edge CAP2.0
}

void T1_isr() 
//ISR which flips the ulse O/P and sets sflag after 1 second
{  
    pulse = !pulse; //  flip the pulse O/P
    count++; 
    if (count >= 10) { 
      count = 0;   //1 second has passed
      sflag = 1;
      }
}

void Timer2_isr()
 //Interrupt caused by +ve pulse on CAP2.0
 //Captured value = period 
 
 {
     if ((LPC_TIM2->IR & 0x10) != 0) {    //Check CAP2.0 Interrupt?
         period = LPC_TIM2->CR0;        //save period
         LPC_TIM2->TC = (0x00);         //Reset Timer2    
         LPC_TIM2->IR = 0x10;           // clear CAP2.0 interrupt
         displed = !displed;            //toggle diagnostic LED
         pflag = 1;                     //New period available           
         }
 }
 
 
int main()
{ 

   Timer2_init();
   
   Tick.attach_us(&T1_isr, 50000);   //initializes the ticker with period of 50msec
                                  //and attaches it to T1 ISR


//Associate Timer2_isr to Interrupt from Timer 2:

   NVIC_SetVector(TIMER2_IRQn, (uint32_t)Timer2_isr); 
   NVIC_EnableIRQ(TIMER2_IRQn); //Enable Interrupts on Timer 2

  

   lcd.cls();
   lcd.locate(0,0);
   lcd.printf("Period in Timer 2 Counts");
    while(1) {
        if (pflag == 1) // new data?
        {        
        lcd.locate(0,15);
        lcd.printf("Period: %d", period); //display captured data
        pflag = 0; //reset flag
        }
        if (sflag ==1){
            led_switch(); //blink light
            sflag = 0;
            }
        }
}
