/* mbed USBHost Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "USBHostPS3DualShock3.h"
 
#if USBHOST_PS3_DUALSHOCK3
 
USBHostPS3DualShock3::USBHostPS3DualShock3() {
    host = USBHost::getHostInst();
    init();
}
 
void USBHostPS3DualShock3::init() {
    dev = NULL;
    int_in = NULL;
    onUpdate = NULL;
    onButtonUpdate = NULL;
    onXUpdate = NULL;
    onYUpdate = NULL;
    onZUpdate = NULL;
    report_id = 0;
    dev_connected = false;
    ps3ds3_device_found = false;
    ps3ds3_intf = -1;
    
    buttons = 0;
    x = 0;
    y = 0;
    z = 0;
}
 
bool USBHostPS3DualShock3::connected() {
    return dev_connected;
}
 
bool USBHostPS3DualShock3::connect() {
 
    if (dev_connected) {
        return true;
    }
    
    for (uint8_t i = 0; i < MAX_DEVICE_CONNECTED; i++) {
        if ((dev = host->getDevice(i)) != NULL) {
 
            if(host->enumerate(dev, this))
                break;
            
            if (ps3ds3_device_found) {
                
                int_in = dev->getEndpoint(ps3ds3_intf, INTERRUPT_ENDPOINT, IN);
                if (!int_in)
                    break;
                
                USB_INFO("New PS3DualShock3 device: VID:%04x PID:%04x [dev: %p - intf: %d]", dev->getVid(), dev->getPid(), dev, ps3ds3_intf);
                dev->setName("PS3DualShock3", ps3ds3_intf);
                host->registerDriver(dev, ps3ds3_intf, this, &USBHostPS3DualShock3::init);
                
                int_in->attach(this, &USBHostPS3DualShock3::rxHandler);
                host->interruptRead(dev, int_in, report, int_in->getSize(), false);
                
                dev_connected = true;
                return true;
            }
        }
    }
    init();
    return false;
}
 
void USBHostPS3DualShock3::rxHandler() {
    int len_listen = int_in->getSize();
    
    if (onUpdate) {
        (*onUpdate)(report[6], report[7], report[8], report[9]);
    }
    
    if (onButtonUpdate && (buttons != (report[6]))) {
        (*onButtonUpdate)(report[6]);
    }
    
    if (onXUpdate && (x != report[7])) {
        (*onXUpdate)(report[7]);
    }
    
    if (onYUpdate && (y != report[8])) {
        (*onYUpdate)(report[8]);
    }
    
    if (onZUpdate && (z != report[9])) {
        (*onZUpdate)(report[9]);
    }
        
    // update ps3ds3 state
    buttons = report[6];
    x = report[7];
    y = report[8];
    z = report[9];
    
    if (dev)
        host->interruptRead(dev, int_in, report, len_listen, false);
}
 
/*virtual*/ void USBHostPS3DualShock3::setVidPid(uint16_t vid, uint16_t pid)
{
    // we don't check VID/PID for ps3ds3 driver
}
 
/*virtual*/ bool USBHostPS3DualShock3::parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol) //Must return true if the interface should be parsed
{
    if ((ps3ds3_intf == -1) &&
        (intf_class == HID_CLASS) &&
        (intf_subclass == 0x00) &&
        (intf_protocol == 0x00)) {
        ps3ds3_intf = intf_nb;
        return true;
    }
    return false;
}
 
/*virtual*/ bool USBHostPS3DualShock3::useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir) //Must return true if the endpoint will be used
{
    if (intf_nb == ps3ds3_intf) {
        if (type == INTERRUPT_ENDPOINT && dir == IN) {
            ps3ds3_device_found = true;
            return true;
        }
    }
    return false;
}
 
#endif
