/*

mbed Can-Bus demo

This program is to demonstrate the CAN-bus capability of the mbed module.

http://www.skpang.co.uk/catalog/product_info.php?products_id=741

v1.0 July 2010

********************************************************************************

WARNING: Use at your own risk, sadly this software comes with no guarantees.
This software is provided 'free' and in good faith, but the author does not
accept liability for any damage arising from its use.

********************************************************************************


*/

#include "mbed.h"
#include "ecu_reader.h"
#include "globals.h"
#include "TextLCD.h"
#include "GPS.h"
#include "SDFileSystem.h"

GPS gps(p28, p27);
TextLCD lcd2(p30, p19, p20, p17, p16, p15, p14);
TextLCD lcd(p18, p19, p20, p17, p16, p15, p14); // rs, rw, e, d0, d1, d2, d3
SDFileSystem sd(p5, p6, p7, p13, "sd");

DigitalIn click(p21);   // Joystick inputs
DigitalIn right(p22);
DigitalIn down(p23);
DigitalIn left(p24);
DigitalIn up(p25);
Serial pc(USBTX, USBRX);



ecu_reader obdii(CANSPEED_500);     //Create object and set CAN speed
void can_demo(void);
void gps_demo(void);
void sd_demo(void);
void home(void);                    // Function to set the screen on a home position

int main() 
{
    pc.baud(115200);
    char buffer[20];
    
    //Enable Pullup 
    click.mode(PullUp);
    right.mode(PullUp);
    down.mode(PullUp);
    left.mode(PullUp);
    up.mode(PullUp);
    
    // Display splash screen
    printf("Vodafone UBI Prototype \n"); 
    lcd.locate(0,0);                // Set LCD cursor position
    lcd.printf("Voda UBI Proto");    
    lcd.locate(0,1);
    lcd.printf("www.vodafone.com");      
    // Wait and clear screen
    wait(3);
    lcd.cls();

    // Call up the home menu
    home();
}


void can_demo(void)
{
    char buffer[20];
    lcd.cls();
    pc.printf("\nVodafone CAN selelected:");
    
    lcd.locate(0,0);                // Set LCD cursor position
    lcd.printf("Voda Car Connect");
    lcd.locate(0,1);
    lcd.printf("CAN bus selected");  

    while(1) 
    {  // Main CAN loop
        if(click == 0) home();
        led2 = 1;
        wait(0.1);
        led2 = 0;
        wait(0.1);
        
        if(obdii.request(ENGINE_RPM,buffer) == 1)   // Get engine rpm and display on LCD
        {
            lcd.locate(0,0);
            lcd.printf(buffer);
              pc.printf(buffer);
        }   
         
        if(obdii.request(ENGINE_COOLANT_TEMP,buffer) == 1)
        {
            lcd.locate(9,0);
            lcd.printf(buffer);
        }
        
        if(obdii.request(VEHICLE_SPEED,buffer) == 1)
        {
            lcd.locate(0,1);
            lcd.printf(buffer);
        }
     
        if(obdii.request(THROTTLE,buffer) ==1 )
        {
            lcd.locate(9,1);
            lcd.printf(buffer);          
        }   
       
    }

}



void home(void)
{
    pc.printf("\nVodafone Home Menu");
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Home - menu");
    lcd.locate(0,1);
    lcd.printf("select option...");
    wait(2);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Use joystick");
    lcd.locate(0,1);
    lcd.printf("U-CAN:D-GPS:P-Ho");   
    pc.printf("\nUse the joystick to select an option - hold down the joystick to get back to home");
    pc.printf("\nUp = CAN buss demo:Down = GPS demo:Left = SD demo: Press = Home");
 
    while(1)    // Wait until option is selected by the joystick
    {
        
        if(down == 0) gps_demo();
        if(left == 0) sd_demo();
        if(up == 0) can_demo();       
    }
  
}


void gps_demo(void)
{
    
    lcd.cls();
    lcd.printf("GPS demo");
    lcd.locate(0,1);
    lcd.printf("Waiting for lock");
    pc.printf("\nVodafone Ublox GPS initiated");
    pc.printf("\nGPS Sampling starting....\n");   

    while(1)
    {
      if(click == 0) home();  
      if(gps.sample()) 
      {
        lcd.cls();
        lcd.printf("Long:%f", gps.longitude);
        lcd.locate(0,1);
        lcd.printf("Lat:%f", gps.latitude);
        pc.printf("I'm at Latitude: %f, Longitude: %f\n", gps.latitude, gps.longitude);
      } 
      else 
      {
        pc.printf("Oh Dear! No lock :(\n");
        lcd.cls();
        lcd.printf("Waiting for lock");
      }
    }

} 

void sd_demo(void)
{
    lcd.cls();
     printf("\nSD demo");
    lcd.printf("SD demo");
    wait(2);      
    lcd.cls();
    
    FILE *fp = fopen("/sd/sdtest2.txt", "w");
    if(fp == NULL) {
        lcd.cls();
        lcd.printf("Could not open file for write\n");
         pc.printf("\nCould not open file for write");
    }
    fprintf(fp, "Hello fun SD Card World! testing 1234");
    fclose(fp); 
    lcd.locate(0,1);
    lcd.printf("Writtern to SD card");
    pc.printf("\nWrittern to SD card");
        
    while(1)
    {
        if(click == 0) home();
        led2 = 1;
        wait(0.1);
        led2 = 0;
        wait(0.1);
   
    }
 
}
