/* lwipopts.h */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#ifndef LWIPOPTS_H_
#define LWIPOPTS_H_

#define NET_PPP 1 //For now only PPP is supported

//Memory
#define MEM_ALIGNMENT 4

#define MEMP_OVERFLOW_CHECK 0 //For debug, will have to be removed once everything is validated to reduce mem consumption and improve performance
#define MEMP_SANITY_CHECK 0 //Same here

#define MEMP_NUM_SYS_TIMEOUT 16

//Debug
#define LWIP_DEBUG 0
#define PPP_DEBUG LWIP_DBG_OFF
#define IP_DEBUG LWIP_DBG_OFF
#define MEM_DEBUG        LWIP_DBG_OFF
#define MEMP_DEBUG       LWIP_DBG_OFF
#define PBUF_DEBUG       LWIP_DBG_OFF
#define API_LIB_DEBUG LWIP_DBG_OFF
#define API_MSG_DEBUG LWIP_DBG_OFF
#define TCPIP_DEBUG                     LWIP_DBG_OFF
#define SOCKETS_DEBUG                   LWIP_DBG_OFF
#define TCP_DEBUG                       LWIP_DBG_OFF
#define TCP_INPUT_DEBUG                 LWIP_DBG_OFF
#define TCP_FR_DEBUG                    LWIP_DBG_OFF
#define TCP_RTO_DEBUG                   LWIP_DBG_OFF
#define TCP_CWND_DEBUG                  LWIP_DBG_OFF
#define TCP_WND_DEBUG                   LWIP_DBG_OFF
#define TCP_OUTPUT_DEBUG                LWIP_DBG_OFF
#define TCP_RST_DEBUG                   LWIP_DBG_OFF
#define TCP_QLEN_DEBUG                  LWIP_DBG_OFF

//Modules to enable
#define LWIP_NETCONN 1
#define LWIP_SOCKET 1
#define TCP_QUEUE_OOSEQ 0
#define LWIP_STATS 0
#define TCP_STATS 0
#define IP_STATS 0
#define LINK_STATS 0
#define MEM_STATS 0
#define MEMP_STATS 0
#define SYS_STATS 0
#define LWIP_STATS_DISPLAY 0
#define LWIP_ARP 0

//Mailboxes
#define TCPIP_MBOX_SIZE 8
#define DEFAULT_TCP_RECVMBOX_SIZE 8
#define DEFAULT_UDP_RECVMBOX_SIZE 8
#define DEFAULT_RAW_RECVMBOX_SIZE 8
#define DEFAULT_ACCEPTMBOX_SIZE 8

//TCP/IP Thread
#define TCPIP_THREAD_STACKSIZE          4*384
#define TCPIP_THREAD_PRIO               1

//Buffers
#define PBUF_POOL_SIZE                  8//16
#define MEMP_NUM_TCP_PCB_LISTEN         4//8
#define MEMP_NUM_TCP_PCB                4//5
#define MEMP_NUM_PBUF                   8//16

#define TCP_SND_BUF (3 * 536)
#define TCP_WND                         (2 * 536)
#define TCP_OVERSIZE                    0 //Disable until it gets fixed in mainline LwIP

#if defined(NET_PPP)
///PPP Options
#define PPP_SUPPORT 1
#define CHAP_SUPPORT                    1
#define PAP_SUPPORT                     1
#define PPP_THREAD_STACKSIZE            4*192
#define PPP_THREAD_PRIO 0

#define MAXNAMELEN                      64     /* max length of hostname or name for auth */
#define MAXSECRETLEN                    64
#elif defined (NET_ETHERNET)

#error Ethernet not supported yet

#else

#warning Application code only

#endif

//DNS
#define LWIP_DNS                        1

//Do not use LwIP's ugly macro-based renaming
#define LWIP_COMPAT_SOCKETS 0
#define LWIP_POSIX_SOCKETS_IO_NAMES 0
#define LWIP_SO_RCVTIMEO 1
#define LWIP_TCP_KEEPALIVE 1


#endif /* LWIPOPTS_H_ */
