/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef USBHOSTKEYBOARD_H
#define USBHOSTKEYBOARD_H

#include "USBHost.h"

class USBHostKeyboard {
public:
    USBHostKeyboard();
    bool connected();

    /**
     * Attach a callback called when a keyboard is received
     *
     * @param fptr function pointer
     */
    void attach(void (*ptr)(uint8_t key)) {
        if (ptr != NULL) {
            onKey = ptr;
        }
    }

    /**
     * Attach a callback called when a keyboard is received
     *
     * @param fptr function pointer
     */
    void attach(void (*ptr)(uint8_t keyCode, uint8_t modifier)) {
        if (ptr != NULL) {
            onKeyCode = ptr;
        }
    }

private:
    USBHost * host;
    USBDeviceConnected * dev;
    Endpoint * int_in;
    Endpoint * int_out;
    uint8_t report[9];
    
    bool dev_connected;

    void rxHandler();

    void (*onKey)(uint8_t key);
    void (*onKeyCode)(uint8_t key, uint8_t modifier);

    int report_id;
    
    void init();

};

#endif
