/* sys_arch.h */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#ifndef SYS_ARCH_H_
#define SYS_ARCH_H_

//Architecture-specific configuration
#define LWIP_SEMAPHORES_COUNT 8
#define LWIP_MUTEXES_COUNT 8
#define LWIP_MAILBOXES_COUNT 8

typedef u32_t sys_prot_t;

struct sys_mutex
{
  /*Mutex**/ void* pMtx;
  int valid;
};
typedef struct sys_mutex sys_mutex_t;

struct sys_sem
{
  /*Semaphore**/ void* pSphre;
  int valid;
};
typedef struct sys_sem sys_sem_t;

#if 0
struct sys_mbox
{
  /*Queue<void>**/ void* pQueue;
  int valid;
};
#else
struct sys_mbox {
  volatile int first, last;
  void * volatile msgs[8];
  struct sys_sem not_empty;
  struct sys_sem not_full;
  struct sys_sem mutex;
  volatile int wait_send;
  volatile int valid;
};
#endif


typedef struct sys_mbox sys_mbox_t;

typedef void/*struct sys_thread*/ sys_thread_t;

#define SYS_MBOX_NULL NULL
#define SYS_SEM_NULL NULL

#endif /* SYS_ARCH_H_ */
