#include "mbed.h"
//#include <bitset>
#include "MMA8452.h"
#include "helperFunctions.h"

// I2C i2c(p28,p27);
Accelerometer_MMA8452 accelerometer(p28, p27, 40000);
//Accelerometer_MMA8452 acclerometer(p28, p29);

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);









int main() {
    led1 = 0;
    led2 = 0;
    led3 = 0;
    char cmd[6];
    char add[1];
    char init[2];
    add[0] = OUT_X_MSB;                                     // x-axis register
    init[0] = CTRL_REG_1;                                   // control register 1
    init[1] = 0x01;                                         // sets the accelerometer to active
    int number=0;
    char x_buffer[2];                                       // used to store a bit array from the x axis acclerometer 
    char y_buffer[2];                                       // this represents the raw data value from the acclerometer
    char z_buffer[2];                                       // which is converted from 12bit to 16bit value 2s compliment.

    // just playing with address values
    char mcu_address = 0x00;
    pc.printf("\nmcu_address is: 0x%x ", mcu_address);
    mcu_address = MMA8452_ADDRESS;
    pc.printf("\nmcu_address is: 0x%x ", mcu_address);
    mcu_address = (MMA8452_ADDRESS<< 1);           // shifting address by 1 bit as i2c is a 7 bit encoding, and this is 8bit encoded
    pc.printf("\nmcu_address is now : 0x%x ", mcu_address);
    
    wait(0.5);
    //init
    //set active mode
    pc.printf("\nWriting to master register\n"); 
    for (int i=0;i<=50;i++)
        {
        int deviceSystemMode= 0;
        if (accelerometer.get_SystemMode(deviceSystemMode)==0)
        {
            pc.printf("\nGot the device System Mode - device system mode which is: 0x%x \n", deviceSystemMode);
        }
        else
        {
            pc.printf("\nFailed to get the device system mode. The id is set as: 0x%x ", deviceSystemMode);
        
        }
        
        int deviceStatus = 0;
        if (accelerometer.get_Status(deviceStatus)==0)
        {
            pc.printf("\nGot the device Status - device status which is: 0x%x \n", deviceStatus);
        }
        else
        {
            pc.printf("\nFailed to get the device status. The id is set as: 0x%x ", deviceStatus);
        
        }
        
        
        
        if (accelerometer.activate()==0)
        {
            led1 = 1;
            led2 = 1;
            led3 = 1;
            pc.printf("\nActivated chip\n"); 
            wait(0.5);
            
            //int x=0;//int y=0;int z=0;
            for(int i=0; i<5;i++)
            {
                
                
                if (accelerometer.read_x_raw(x_buffer)==0)
                {
                    //pc.printf("\nThe x-axis LSB is: 0x%x", x);
                    pc.printf("The value of my x_buffer[0] in digit form is: %d  in hex:  0x%x  \n",x_buffer[0],x_buffer[0]);
                    pc.printf("The value of my x_buffer[1] in digit form is: %d  in hex:  0x%x  \n",x_buffer[1],x_buffer[1]);
                    print2bytebinchar(x_buffer);
                    
                }
                else
                {
                    pc.printf("\nError - could not get xaxis LSB! ....\n");
                }
                
                
                
                if (accelerometer.read_y_raw(y_buffer)==0)
                {
                    //pc.printf("\nThe x-axis LSB is: 0x%x", x);
                    pc.printf("The value of my y_buffer[0] in digit form is: %d  in hex:  0x%x  \n",y_buffer[0],y_buffer[0]);
                    pc.printf("The value of my y_buffer[1] in digit form is: %d  in hex:  0x%x  \n",y_buffer[1],y_buffer[1]);
                    print2bytebinchar(y_buffer);
                    
                }
                else
                {
                    pc.printf("\nError - could not get yaxis LSB! ....\n");
                }
                

                
                if (accelerometer.read_z_raw(z_buffer)==0)
                {
                    //pc.printf("\nThe x-axis LSB is: 0x%x", x);
                    pc.printf("The value of my z_buffer[0] in digit form is: %d  in hex:  0x%x  \n",z_buffer[0],z_buffer[0]);
                    pc.printf("The value of my z_buffer[1] in digit form is: %d  in hex:  0x%x  \n",z_buffer[1],z_buffer[1]);
                    print2bytebinchar(y_buffer);
                    
                }
                else
                {
                    pc.printf("\nError - could not get zaxis LSB! ....\n");
                }
                

                
                //y = accelerometer.read_y();
                
                //pc.printf("\nAxis acceleration in x is: %i  , y is: %i, z is %z \n", x,y,z);
                wait(1);
            }      
        }
        else
        {
            pc.printf("Could not activate the chip\n");
        }
        
        
        int deviceID= 0;
        if (accelerometer.get_DeviceID(deviceID)==0)
        {
            pc.printf("\nGot the who am I - device id which is: 0x%x \n", deviceID);
        }
        else
        {
            pc.printf("\nFailed to get the device id. The id is set as: 0x%x ", deviceID);
        
        }
        
        if (accelerometer.get_Status(deviceStatus)==0)
        {
            pc.printf("\nGot the device Status - device system mode which is: 0x%x \n", deviceSystemMode);
        }
        else
        {
            pc.printf("\nFailed to get the device system mode. The id is set as: 0x%x ", deviceSystemMode);
        
        }

        wait(3);
        
        pc.printf("In loop %d, of repeated initialisation.\n",i); 
        i++;
     }   
    
    //get analog data
    pc.printf("Set system into standby mode.........");
    
    if(accelerometer.standby()==0)
    {
        pc.printf("Device set into standby...\n");
    }
    else
    {
        pc.printf("Device failed to set into standby...\n");
    }
    int deviceSystemMode = 0;
    pc.printf("\nGet system mode, it should now be standby! ...\n");
    if (accelerometer.get_SystemMode(deviceSystemMode)==0)
    {
        pc.printf("\nGot the device System Mode - device system mode which is: 0x%x \n", deviceSystemMode);
    }
    else
    {
        pc.printf("\nFailed to get the device system mode. The id is set as: 0x%x ", deviceSystemMode);
        
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /*
    while(1) 
    {
        //send procedure
        wait(0.07);
        switch(number){
        case 0:
            if(i2c.write(mcu_address,add,1) == 0){
                number++;
                pc.printf("In case 0 loop. The number is: %d \n", number);
                led1 = 1;
            }else{
                number=0;
                pc.printf("In case 0 loop. The number is reset to: %d \n", number);
                led1 = 0;
                led2 = 0;
                led3 = 1;
            }
            break;
        case 1:
            if(i2c.read(mcu_address,cmd,6) == 0){
                number++;
                pc.printf("In case 1 loop. The number is: %d \n", number);
                led2 = 1;
            }else{
                number=0;
                pc.printf("In case 1 loop. The number is reset to: %d \n", number);
                led1 = 0;
                led2 = 0;
                led3 = 0;
            }
            break;    
        case 2:
            //get analog data
            pc.printf("\r X = %d,Y = %d,Z = %d                \n",cmd[1],cmd[3],cmd[5]);
            led3 = 1;
            wait(0.5);
            led1 = 0;
            led2 = 0;
            led3 = 0;
            number=0;
            break;
        }
    }*/
    
}
