#include "mbed.h"
#include "C027.h"
#include "UbloxUSBGSMModem.h"
#include "UbloxUSBCDMAModem.h"

#define USSD_COMMAND "*#100#"

C027 c027;

void test(void const*)
{
    printf("Starting USSD test on Ublox C027, first calling mdmPower for the modem \n");
    c027.mdmPower(true);
    printf("Waiting 15 sec for modem to settle after power on...");
    for(int x=1;x<=15;x++)
    {
        wait(1);
        printf(".");
    }
        
    
    
    printf("Creating modem object...\n");
    UbloxUSBGSMModem modem; // for LISA-C use the UbloxUSBCDMAModem instead
    char result[32];
    printf("\nWaiting 15 sec for modem to settle, just created the modem object.\n");
    for(int x=1;x<=15;x++)
    {
        wait(1);
        printf(".");
    }
    
    
    printf("\n....wait over!\n");
    printf("Sending %s on USSD channel\n", USSD_COMMAND);
    int ret = modem.sendUSSD(USSD_COMMAND, result, 32);
    
    if(ret) {
        printf("Send USSD command returned %d\n", ret);
    }

    printf("Result of command: %s\n", result);

    c027.mdmPower(false);
    
    while(1) {
    }
}


int main()
{
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    DigitalOut led(LED); // on rev A you should reasign the signal to A0
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
