#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "net_3g_basic_http_test.cpp"
#endif

#include "mbed.h"
#include "rtos.h"
#include "VodafoneUSBModem.h"
#include "socket/bsd_socket.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut latch(p15);
DigitalOut enable(p16);
SPI spi(p11, p12, p13);

void setLEDColor(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

void setupShifty() {
   spi.format(16,0);
   spi.frequency(500000);
   enable=0;
   latch=0;
}

void doRainbow() {
   for(int r=0; r<500; r++) {
      for(int g=0; g<500; g++) {
         for(int b=0; b<500; b++) {
            setLEDColor(r,g,b);
         }
      }
   }
   setLEDColor(500,500,500);
   Thread::wait(1000);
   setLEDColor(0,0,0);
}

void doFlash() {
   int interval = 100;
   for(int i=0; i<5; i++) {
      setLEDColor(500,0,0);
      Thread::wait(interval);
      setLEDColor(0,0,0);
      Thread::wait(interval);
      setLEDColor(500,500,500);
      Thread::wait(interval);
      setLEDColor(0,0,0);
      Thread::wait(interval);
      setLEDColor(0,0,500);
      Thread::wait(interval);
      setLEDColor(0,0,0);
      Thread::wait(interval);
   }
   setLEDColor(500,0,0);
}


void lightListener(void const*) {
  VodafoneUSBModem modem;
  // socket stuff
  int sockfd,ret = OK;
  uint16_t port = 3232;
  struct sockaddr_in serverAddress;
  struct hostent *server;
  char urlBuffer[128];
  int urlBufferLength = 128;

  // declare space for phone number and message storage
  char numBuffer[20], msgBuffer[256];
  size_t numSMS; // variable to track number of received messages

  //int ret = modem.connect("internet","web","web");
 
  if(ret == OK) {
    int count = 30;
    int rssi;
    int r=0,g=0,b=0;
    LinkMonitor::REGISTRATION_STATE regState;
    LinkMonitor::BEARER bearer;
    while(1) {    
        
        //modem.getLinkState(&rssi, &regState, &bearer);
        //DBG("RSSI: %d dBm; Reg state: %d; Bearer: %d", rssi, regState, bearer);

        // retrieve the short message count into numSMS
        if(modem.getSMCount(&numSMS)==OK) {
            // check if any short messages have been received
            if(numSMS>0) {
                DBG("SM count > 0");
                // get the oldest short message in the queue
                if(modem.getSM(numBuffer,msgBuffer,256)==OK) {
                    if(strcmp(msgBuffer,"flash")==0) {
                       doFlash();
                       continue;
                    } else if(strcmp(msgBuffer,"rainbow")==0) {
                       doRainbow();
                       continue;
                    } else if(strcmp(msgBuffer,"red")==0) {
                       setLEDColor(1000,0,0);
                       continue;
                    } else if(strcmp(msgBuffer,"green")==0) {
                       setLEDColor(0,1000,0);
                       continue;
                    } else if(strcmp(msgBuffer,"blue")==0) {
                       setLEDColor(0,0,1000);
                       continue;
                    } else if(strcmp(msgBuffer,"purple")==0) {
                       setLEDColor(1000,0,1000);
                       continue;
                    } else if(strcmp(msgBuffer,"off")==0) {
                       setLEDColor(0,0,0);
                       continue;
                    }
                    
                    if(sscanf(msgBuffer,"%d,%d,%d",&r,&g,&b)!=3) {
                       continue;
                    }
                    DBG("Setting light to: %d,%d,%d",r,g,b);
                    
                    if(r<256) {
                       r *= 4;
                    }
                    
                    if(g<256) {
                       g *= 4;
                    }
                    
                    if(b<256) {
                       b *= 4;  
                    }
                    
                    if(r>1023) {
                       r = 1023;
                    }
                    
                    if(g>1023) {
                       g = 1023;
                    }
                    
                    if(b>1023) {
                       b = 1023;
                    }
                    
                    setLEDColor(r,g,b);
                    
                    
                    // connect to socket and push message
                    /*
                    // create the socket
                    if((sockfd=::socket(AF_INET,SOCK_STREAM,0))<0) { DBG("Error opening socket\r\n"); } else { DBG("Socket open\r\n"); }
                         
                    // create the socket address
                    std::memset(&serverAddress, 0, sizeof(struct sockaddr_in));
                    if((server=::gethostbyname("m2mthings.com"))==NULL)  {
                         DBG("Error resolving address, setting manually.");
                         serverAddress.sin_addr.s_addr = inet_addr("109.74.199.96");
                    } else {
                         DBG("Address resolved OK");
                         memcpy((char*)&serverAddress.sin_addr.s_addr, (char*)server->h_addr_list[0], server->h_length);
                    }
                    // set server address family
                    serverAddress.sin_family = AF_INET;
                    // set server port
                    serverAddress.sin_port = htons(port);
         
                    // do socket connect
                    DBG("Connecting socket to %s:%d", inet_ntoa(serverAddress.sin_addr), ntohs(serverAddress.sin_port));
                    if((ret=::connect(sockfd, (const struct sockaddr *)&serverAddress, sizeof(serverAddress)))<0) {
                         ::close(sockfd);
                         DBG("Could not connect");
                    } else {
                         DBG("Connection OK");
                    }
                    
                    DBG("Sending password");
                    ::write(sockfd,"hi3h892!",8);
                    
                    ret = ::recv(sockfd,urlBuffer,urlBufferLength,0);
                    if (ret<0) {
                        DBG("Error receiving ACK.");
                    } else {
                        DBG("Received(%d): %s",urlBufferLength,urlBuffer);
                        modem.sendSM(numBuffer,urlBuffer);
                    }
                    
                    ::close(sockfd);
                    */

                }
            }
        }
        // wait 500ms
        Thread::wait(500);
    }
    
  }
  
  //modem.disconnect();
  //DBG("Disconnected");

  while (1) {
    Thread::wait(100);
  }
}

void keepAlive(void const*) {
  while (1) {
    led1 = !led1;
    Thread::wait(250);
    led1 = !led1;
    Thread::wait(750);
  }
}

int main() {
   DBG_INIT();
   DBG_SET_SPEED(115200);
   DBG_SET_NEWLINE("\r\n");
   int red=0;
   int green=0;
   int blue=0;
   setupShifty();
   setLEDColor(500,200,200);
   
   Thread lightTask(lightListener, NULL, osPriorityNormal, 1024 * 6);
   keepAlive(NULL);
}