#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "SDFileSystem.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Ticker flipper;
Ticker flipper2;
Ticker flipper3;
Ticker flipper4;
/*
//part 1
void flip1() {
    led1 = !led1;
}
void flip2() {
    led2 = !led2;
}
void flip3() {
    led3 = !led3;
}
void flip4() {
    led4 = !led4;
}
int main() {
//%%%%%%%%%%%%%%
    flipper.attach(&flip1, .5);
    flipper2.attach(&flip2, 1);
    flipper3.attach(&flip3, 2);
    flipper4.attach(&flip4, 4);
//%%%%%%%%%%%%%%
}
*/

//part 2
//shiftbrite setup

DigitalOut latch(p15);
DigitalOut enable(p16);
SPI spi(p11, p12, p13);
//SD card and amp set up
SDFileSystem sd(p5, p6, p7, p8, "sd");//SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
Mutex uLCD_mutex;
DigitalOut ampShutdown(p20);
uLCD_4DGL uLCD(p28, p27, p29); 

void notify(const char* name, int state) {
    //wait until the mutex is available for us to lock
    led2 = 1;
    //while(!uLCD_mutex.trylock());    
    //>>>Critical Section
    uLCD_mutex.lock();
    //print the name of the thread you are on
    uLCD.printf("%s: %d\n\r", name, state);
    uLCD_mutex.unlock();
}

void test_thread(void const *args) {
    //led3 = 1;
    while (true) {
        notify((const char*)args, 0); Thread::wait(2000);
        notify((const char*)args, 1); Thread::wait(2000);
    }
}
unsigned int red, blue, green = 0;
unsigned int low_color=0;
unsigned int high_color=0;

void shiftBrite(void const *args) {
    while (true) {
        led4 = 1;
        red = (red + 1)%255;
        blue = (blue + 3) %255;
        green = (green + 5)%255;
        high_color=(blue<<4)|((red&0x3C0)>>6);
        low_color=(((red&0x3F)<<10)|(green));
        led4 = 0;
        spi.write(high_color);
        spi.write(low_color);
        latch=1;
        latch=0;
        Thread::wait(400);
    }
}

//main is already a thread
int main () {
    //shift brite initialization
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    wait(2);
    //ampShutdown = 1;
    uLCD.cls();

    //thread initialization
    Thread thread2(shiftBrite, (void *) "Th 2");
    Thread thread3(test_thread, (void *)"Th 3");
    Thread thread4(test_thread, (void *)"Th 4");
    led1 = 1;
    
    FILE *wave_file;
    
    while(1) {
    led2 = 1;
    wave_file=fopen("/sd/sample.wav","r");
    led3 = 1;
    waver.play(wave_file);
    led4 = 1;
    fclose(wave_file);
    }
}
