#include "mbed.h"
#include <AD5933.h>
#include <string>
#include <list>
#include <math.h>
# define M_PI           3.14159265358979323846  /* pi */

long double z;
long double phs;
int f;
int freq;
bool ready = false;

//setup buffer for data transfer
char buff[10];

// For displaying input frequency
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//For inputting frequency
AnalogIn fIn(p19);

//Button for inputting frequency
DigitalIn changeF(p7);

// Setup the i2c bus on pins 9 and 10
I2C i2c(p28, p27);  //sda, scl

//MCLK on p22
PinName mclk(p22);

// Setup the Serial to the PC also for debugging
Serial pc(USBTX, USBRX);

// Setup Bluetooth serial communication
Serial bt(p13, p14);

// Setup AD5933
AD5933 AD5933(&i2c, &pc, &bt);

void updateF() {
    f = fIn * 4 + 1;
    led2 = f & 0x4;
    led3 = f & 0x2;
    led4 = f & 0x1;
    if(!changeF){
        freq = f * 100000;
        ready = true;
    }
}

void readZ() {
    bt.putc('.');
    pc.printf("Calculating and retrieving magnitude and phase\n\r");
    AD5933.findZ(f);

    bt.putc('.');
    z = AD5933.getZ();
    phs = AD5933.getPhase();
    if(phs < 0)
        phs += 2 * M_PI;
    phs /= M_PI;
    phs *= 180;
    //send data
    sprintf(buff, "%.0f %.0f;", z, phs);
    for(int i = 0; i < 10; i++)
    {
        bt.putc(buff[i]);
    }
    pc.printf("z: %f, phs: %f", z, phs);
}
int main()
{    
    //setup communication rates
    bt.baud(9600);
    AD5933.calibrate(200000);
    while(1){
        updateF();
        if(ready){
            readZ();
        } else {
            bt.putc('.');
        }
    }
}