#include <mbed.h>
#include "uLCD_4DGL.h"

#ifndef AD5933_H
#define AD5933_H

class AD5933
{
    public:
        //constructor
        AD5933(I2C* i2c, Serial *pc, Serial *bt);
        
        //functions
        void    calibrate(double);   //setup device
        void    findZ(int);         //finds impedance
        float   getZ();             //returns impedance
        float   getPhase();         //returns phase
    private:
    //devices
        I2C* _i2c;
        Serial* _pc;
        Serial* _bt;
    //variables
        //data
        int _real[10];    //real/imaginary values for a sweep
        int _imag[10];
        int _r;        //real/imaginary values for a single frequency reading
        int _i;
        int _temp[2];   //temperature (calibrated and current value)
        long double _z;       //impedance array
        long double _phs;     //real phase array
        //for calibration
        long double _gain[10];  //gain
        float _phase[10]; //phase
        float _ref;     //reference resistance
        //settings
        int _range;     //output voltage range
        int _freq;      //start frequency
        int _inc;       //increment
        int _n;         //number of increments
        char _pga;
    //functions
        void sweep();       //gets the data
        void sweep1();
        void configure();   //ready the device for sweep
        void read(int);     //get value
        void calculate();   //cleans value
        float getTemp();    //returns temperature
};

//Register defines

//control
#define CTRL_HIGH   0x80
#define CTRL_LOW    0x81
//start frequency
#define FREQ_HIGH   0x82
#define FREQ_MID    0x83
#define FREQ_LOW    0x84
//frequency increment
#define FINC_HIGH   0x85
#define FINC_MID    0x86
#define FINC_LOW    0x87
//number of increments
#define NINC_HIGH   0x88
#define NINC_LOW    0x89
//number of settling time cycles
#define SET_CYCLE   0x8A
#define CYCLES      0x8B
//status
#define STATUS      0x8F
//temperature data
#define TEMP_HIGH   0x92
#define TEMP_LOW    0x93
//real data
#define REAL_HIGH   0x94
#define REAL_LOW    0x95
//imaginary data
#define IMAG_HIGH   0x96
#define IMAG_LOW    0x97

//Constants

// Temperature measuring
#define TEMP_MEASURE    (CTRL_TEMP_MEASURE)
#define TEMP_NO_MEASURE (CTRL_NO_OPERATION)
// Clock sources
#define CLOCK_INTERNAL  (CTRL_CLOCK_INTERNAL)
#define CLOCK_EXTERNAL  (CTRL_CLOCK_EXTERNAL)
// PGA gain options
#define PGA_GAIN_X1     (CTRL_PGA_GAIN_X1)
#define PGA_GAIN_X5     (CTRL_PGA_GAIN_X5)
// Power modes
#define POWER_STANDBY   (CTRL_STANDBY_MODE)
#define POWER_DOWN      (CTRL_POWER_DOWN_MODE)
#define POWER_ON        (CTRL_NO_OPERATION)
// I2C result success/fail
#define I2C_RESULT_SUCCESS       (0)
#define I2C_RESULT_DATA_TOO_LONG (1)
#define I2C_RESULT_ADDR_NAK      (2)
#define I2C_RESULT_DATA_NAK      (3)
#define I2C_RESULT_OTHER_FAIL    (4)
// Control register options
#define CTRL_NO_OPERATION       (0b00000000)
#define CTRL_INIT_START_FREQ    (0b00010000)
#define CTRL_START_FREQ_SWEEP   (0b00100000)
#define CTRL_INCREMENT_FREQ     (0b00110000)
#define CTRL_REPEAT_FREQ        (0b01000000)
#define CTRL_TEMP_MEASURE       (0b10010000)
#define CTRL_POWER_DOWN_MODE    (0b10100000)
#define CTRL_STANDBY_MODE       (0b10110000)
#define CTRL_RESET              (0b00010000)
#define CTRL_CLOCK_EXTERNAL     (0b00001000)
#define CTRL_CLOCK_INTERNAL     (0b00000000)
#define CTRL_PGA_GAIN_X1        (0b00000001)
#define CTRL_PGA_GAIN_X5        (0b00000000)
// Status register options
#define STATUS_TEMP_VALID       (0x01)
#define STATUS_DATA_VALID       (0x02)
#define STATUS_SWEEP_DONE       (0x04)
#define STATUS_ERROR            (0xFF)
// Frequency sweep parameters
#define SWEEP_DELAY             (1)

#endif