#include "GasArray.h"
#include <string>
#include <cmath>

GasArray::GasArray(int n, float bR[], float mV, float dR[], AnalogIn p[], float is[], string t[], string g[])
{
    //load array information
    number = n;
    baseR = bR;
    pwrV = mV;
    dividerR = dR;
    pins = p;
    InverseSensitivity = is;
    types = t;
    gases = g;
    
    //initialize other members
    responseV = new float [n];
    sensorR = new float [n];
    percentages = new float [n];
}

void GasArray::read()               // Reads and saves sensor responses
{
    //read responses, get percentages
    for(int i = 0; i < number; i++)
    {
        //get divided voltage
        responseV[i] = pwrV*(pins[i].read());
        //get sensor responses
        sensorR[i] = ((responseV[i]*dividerR[i])/(pwrV-responseV[i])-baseR[i])/baseR[i];
    }
    //get percentages
    for(int i=0; i<number; i++)
    {
        float sum = 0;
        for(int j=0; j<number; j++)
        {
            sum += InverseSensitivity[i*number+j]*sensorR[j];
        }
        percentages[i] = sum;
    }
}

void GasArray::display_init(uLCD_4DGL *uLCD) // Displays sensor types
{
    uLCD -> cls();
    //print sensor types
    for(int i=0; i<number; i++)
    {
        uLCD -> locate(1, 2*i+1);
        uLCD -> printf("%s", types[i]);
    }
    //print gas names
    for(int i=0; i<number; i++)
    {
        uLCD -> locate(1, 2*i+1+3*number);
        uLCD -> printf("%s", gases[i]);
    }
}

void GasArray::display_cont(uLCD_4DGL *uLCD)
{
    //print sensor responses
    for(int i=0; i<number; i++)
    {
        uLCD -> locate(10,2*i+1);
        uLCD -> printf("%2.03f", sensorR[i]);
    }
    //print gas percentages
    for(int i=0; i<number; i++)
    {
        uLCD -> locate(10,2*i+1+3*number);
        uLCD -> printf("%2.03f", percentages[i]);
    }
}