#include "mbed.h"
#include "GasArray.h"
#include "string.h"

//base sensors' resistances
float baseR[] = {9000, 650000};

//number of sensors
int number = 2;

//input total voltage across divider
float pwrV = 3;

//corresponding divider resistances
float dividerR[] = {1000, 201000};

//corresponding sensor pins (analog in)
AnalogIn places[] = {A0, A1};

//sensitivity matrix (ONLY TAKES SQUARE MATRICES)
float ISensitivityM[] = {-0.5,-0.001,-1,-0.0024};

//sensor types
string type[] = {"p-type", "n-type"};

//gases
string gas[] = {"NO", "NO2"};

//tare button
InterruptIn tareButton(p5);

//initialize screen
uLCD_4DGL uLCD(p28, p27, p29);

//establish sensor array
GasArray Device(number, baseR, pwrV, dividerR, places, ISensitivityM, type, gas);

void zero()
{
    Device.tare();
}

int main()
{
    //setup button
    tareButton.rise(&zero);
    //setup screen
    uLCD.display_control(PORTRAIT);
    uLCD.cls();
    uLCD.baudrate(BAUD_3000000);
    uLCD.background_color(BLACK);
    //include cool credit
    uLCD.printf("Georgia Tech \n\n Sensors and\n Catalysis Lab \n\n in collaboration  with \n\n Hardy\n Technologies");
    wait(.5);
    
    //display percentages
    Device.display_init(&uLCD);
    //continuously update
    while(1)
    {
        //read voltages
        Device.read();
        //display percentages
        Device.display_cont(&uLCD);
    }
}