#include "mbed.h"
#include "uLCD_4DGL.h"
#include <string>

class GasArray
{
    public:
        GasArray(int, float[], float, float[], AnalogIn[], float[], string[], string[]);
        void read();                        // Returns voltage values
        void display_init(uLCD_4DGL *uLCD); // Prints sensor types and gases
        void display_cont(uLCD_4DGL *uLCD); // Prints response and gas percentages
        void tare();                        // Adjusts base resistances for no gas
    private:
        int number;                         // Number of sensors
        float * baseR;                      // Base resistance of sensors
        float pwrV;                         // Store total voltage across divider
        float * dividerR;                   // Voltage divider resistors
        AnalogIn * pins;                    // Pins 15-20
        float * responseV;                  // Store sensors' response voltages
        float * sensorR;                    // Store sensors' responses
        float * InverseSensitivity;         // Inverse sensitivity matrix
        string * types;                     // Sensor types
        string * gases;                     // List of gas for display
        float * percentages;                // Store gas percentages
};