
//--------------------------------------------------------------

#ifndef FILE_SELECTOR_HPP
#define FILE_SELECTOR_HPP

#include "F746_GUI.hpp"
#include "SD_WavReader.hpp"
#include <algorithm>    // Được sử dụng bởi sort() 
#include <string>

namespace Mikami
{
    class FileSelector
    {
    public:
        FileSelector(uint8_t x0, uint8_t y0, int maxFiles,
                     int maxNameLength, SD_WavReader &reader);

        virtual ~FileSelector();
        
       // Lập danh sách các tập tin. Trả về false nếu tệp WAV không tồn tại
        bool CreateTable();
        // chọn tập tin
        bool Select(string &fileName);

        // Hiển thị danh sách các tập tin
        void DisplayFileList(bool sortEnable = true);

        // xóa danh sách các tập tin
        void Erase(uint16_t x, uint16_t y, uint16_t width, uint16_t height,
                   uint32_t color = GuiBase::ENUM_BACK);

    private:
        static const int MAX_LIST_PAGE_ = 6;  // Số lượng tệp tối đa được hiển thị trên một trang
        static const uint8_t W_H_ = 24;
        static const uint8_t V_L_ = 36;
        static const uint32_t BASE_COLOR_ = 0xFF80FFA0;
        static const uint32_t TOUCHED_COLOR_ = 0xFF80FFFF;
        const uint8_t X_, Y_;
        const int MAX_FILES_;
        const int MAX_NAME_LENGTH_;
        
        Array<string> fileNames_;
        Array<Label *> fileNameLabels_;
        ButtonGroup *rect_;
        ButtonGroup next_;
        Label pageLabel_;
        LCD_DISCO_F746NG &lcd_;
        SD_WavReader &sdReader_;
        int page_;      // Trang hiện tại, trang đầu tiên là 1
        int nOld_;      // Chỉ mục của tệp đã chọn trước đó trong trang
        int kOld_;      // Chỉ mục của tệp đã chọn trước đó
        int maxPage_;
        int fileCount_;

        // Lấy tên tệp với phần mở rộng bị xóa
        string GetFileNameNoExt(int n);

        // Không sử dụng các hàm tạo sao chép và toán tử gán đối tượng
        FileSelector(const FileSelector&);
        FileSelector& operator=(const FileSelector&);
    };
}
#endif  // FILE_SELECTOR_HPP

