//--------------------------------------------------------------

#ifndef F746_SD_PLAYER_SKELETON_HPP
#define F746_SD_PLAYER_SKELETON_HPP

#include "SAI_InOut.hpp"
#include "F746_GUI.hpp"
#include "FileSelectorWav.hpp"
#include "SD_WavReader.hpp"

using namespace Mikami;

namespace Mikami
{
    class SD_PlayerSkeleton
    {
    public:
        // Đặt resetButton thành true nếu sử dụng nút reset
        SD_PlayerSkeleton(string str, bool resetButton = false);
        virtual ~SD_PlayerSkeleton() { if (reset_ != NULL) delete reset_; }
       // thực thi xử lý trình phát SD
        void Execute();

    protected:
       
        static const uint16_t BG_LEFT_ = 414;
        static const uint16_t BG_WIDTH_ = 66;
        static const uint16_t BG_HEIGHT_ = 36;
    
        const int32_t BUFF_SIZE_;   // Kích thước của bộ đệm
        Array<int16_t> sn_;         // bộ đệm

        SaiIO mySai_;
        SD_WavReader sdReader_; // Đối tượng đọc thẻ SD

        // Lấy tên tệp đã chọn
        string GetFileName() { return fileName_; }
        // Nhận tên tệp đã chọn mà không có phần mở rộng
        string GetFileNameNoExt();

    private:
        string fileName_;       // Tên tệp đã chọn
        Label title_;           // Tiêu đề hiển thị ở trên cùng
        FileSelector selector_;
        ButtonGroup menu_;
        ResetButton *reset_;    // Con trỏ cho nut Reset

        // Mở tệp thẻ SD
        int32_t SD_Open();
       // Chọn tệp
        void SelectFile();
      // Xử lý khi bảng điều khiển được vận hành
        void DoIfHandled();
// Đợi trong khi thực hiện Do IfHandled () cho đến khi một trong các nút menu được chạm
        int WaitTouched();

       // Không sử dụng hàm tạo sao chép và toán tử gán đối tượng
        SD_PlayerSkeleton(const SD_PlayerSkeleton&);
        SD_PlayerSkeleton& operator=(const SD_PlayerSkeleton&);

        virtual void SignalProcessing() = 0;
        // Thay đổi tham số xử lý tín hiệu, v.v.
        virtual void Modefy() {}
       // Hiển thị khi phát một bài hát
        virtual void Display() {}
        // *Xóa quá trình cần thiết để xử lý tín hiệu*//
        virtual void Clear() {}
    };
}
#endif  // F746_SD_PLAYER_SKELETON_HPP
