
//--------------------------------------------------------------

#ifndef SD_WAV_READER_HPP
#define SD_WAV_READER_HPP

#include "stm32746g_discovery_audio.h"
#include "SDFileSystem.h"
#include "BlinkLabel.hpp"
#include "Array.hpp"
#include <string>

namespace Mikami
{
    class SD_WavReader
    {
    public:
        SD_WavReader(int32_t bufferSize);
        virtual ~SD_WavReader();

        void Open(const string fileName);
        
        void Close() { fclose(fp_); }
        
      // Đọc tiêu đề của tệp
        bool IsWavFile();

      // Nhận dữ liệu âm thanh nổi từ tệp
        void ReadStereo(Array<int16_t>& dataL, Array<int16_t>& dataR);

        // Chuyển đổi dữ liệu từ tệp thành đơn âm
        void ReadAndToMono(Array<int16_t>& data);
        
      // Lấy kích thước dữ liệu (số điểm lấy mẫu)
        int32_t GetSize();

    private:
        const string STR_;
        
        struct WaveFormatEx
        {
            uint16_t wFormatTag;        // 1: PCM
            uint16_t nChannels;        // 1: 1: đơn âm, 2: âm thanh nổi
            uint32_t nSamplesPerSec;    // Tần số lấy mẫu (Hz)
            uint32_t nAvgBytesPerSec;   // Tốc độ truyền (byte / s)
            uint16_t nBlockAlign;       // 4: Trong trường hợp âm thanh nổi 16 bit
            uint16_t wBitsPerSample;    // Số bit dữ liệu, 8 hoặc 16
            uint16_t cbSize;            // Không được sử dụng cho PCM
        };

        SDFileSystem *sd_;
        FILE *fp_;
        
        bool ok_;
        int32_t size_;          // Kích thước dữ liệu (số điểm lấy mẫu)
        Array<int16_t> buffer;  // Khu vực làm việc
        
        void ErrorMsg(char msg[])
        {   BlinkLabel errLabel(240, 100, msg, Label::CENTER); }
// Không sử dụng hàm tạo sao chép và toán tử gán đối tượng
        SD_WavReader(const SD_WavReader&);
        SD_WavReader& operator=(const SD_WavReader&);
    };
}
#endif  // SD_BINARY_READER_HPP
