

/*
 *
 * vivaldi16
 *
 * created with FontCreator
 * written by F. Maximilian Thiele
 *
 * http://www.apetech.de/fontCreator
 * me@apetech.de
 *
 * File Name           : vivaldi16.h
 * Date                : 31.12.2010
 * Font size in bytes  : 22998
 * Font width          : 10
 * Font height         : 16
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */


#ifndef VIVALDI16_H
#define VIVALDI16_H

#define VIVALDI16_WIDTH 10
#define VIVALDI16_HEIGHT 16

const unsigned int vivaldi16[]  = {
    0x59, 0xD6, // size
    0x0A, // width
    0x10, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x05, 0x08, 0x15, 0x10, 0x15, 0x16, 0x04, 0x0B, 0x0B, 
    0x07, 0x08, 0x05, 0x07, 0x05, 0x0B, 0x12, 0x0E, 0x11, 0x11, 
    0x13, 0x12, 0x13, 0x0E, 0x12, 0x13, 0x05, 0x06, 0x06, 0x08, 
    0x06, 0x0C, 0x0A, 0x16, 0x16, 0x14, 0x18, 0x15, 0x15, 0x16, 
    0x19, 0x0E, 0x11, 0x19, 0x15, 0x1B, 0x17, 0x14, 0x16, 0x15, 
    0x18, 0x12, 0x13, 0x17, 0x15, 0x1D, 0x17, 0x14, 0x13, 0x06, 
    0x0B, 0x06, 0x08, 0x08, 0x06, 0x0E, 0x0F, 0x0E, 0x10, 0x0E, 
    0x0C, 0x0F, 0x12, 0x0A, 0x08, 0x13, 0x09, 0x1B, 0x12, 0x0F, 
    0x10, 0x0F, 0x0E, 0x0D, 0x0A, 0x12, 0x11, 0x19, 0x13, 0x11, 
    0x0E, 0x08, 0x04, 0x08, 0x08, 0x05, 
    
    // font data
    0x18, 0x7C, 0xFC, 0x7C, 0x18, 0x08, 0x1C, 0x1D, 0x1C, 0x08, // 33
    0x1C, 0x7C, 0x7C, 0x1C, 0x04, 0x7C, 0x7C, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x00, 0x00, 0x80, 0x40, 0x40, 0x40, 0xC0, 0xE0, 0xF8, 0x78, 0x78, 0x48, 0xC0, 0xC0, 0xF0, 0xF8, 0x78, 0x58, 0x40, 0x40, 0x40, 0x04, 0x02, 0x0A, 0x0A, 0x0E, 0x0F, 0x07, 0x03, 0x03, 0x0A, 0x0E, 0x0E, 0x0F, 0x07, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, // 35
    0xF0, 0xF8, 0xF8, 0xFC, 0xEC, 0xEC, 0xCC, 0xCE, 0xCE, 0xCE, 0xD8, 0xD8, 0xD8, 0xBC, 0x80, 0x00, 0x1F, 0x0E, 0x0C, 0x0D, 0x0D, 0x09, 0x19, 0x79, 0x79, 0x79, 0x1B, 0x1B, 0x1F, 0x1F, 0x0F, 0x07, // 36
    0x30, 0x78, 0xFC, 0x8C, 0x84, 0x84, 0x8C, 0xFC, 0x78, 0x30, 0x80, 0x40, 0x30, 0x98, 0x8C, 0x84, 0x84, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x18, 0x0C, 0x06, 0x03, 0x00, 0x06, 0x0F, 0x1F, 0x11, 0x10, 0x10, 0x11, 0x1F, 0x0F, 0x06, // 37
    0x00, 0x00, 0x80, 0x80, 0x80, 0xC0, 0xF8, 0xFC, 0xFE, 0xFE, 0xE6, 0xE6, 0xFE, 0x3C, 0x58, 0x40, 0xC0, 0xC0, 0xC0, 0x40, 0x40, 0x40, 0x06, 0x0F, 0x0F, 0x0F, 0x1F, 0x1F, 0x1C, 0x18, 0x19, 0x1B, 0x1B, 0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1F, 0x1F, 0x1D, 0x1C, 0x1E, 0x0E, // 38
    0x1C, 0x7C, 0x7C, 0x3C, 0x00, 0x00, 0x00, 0x00, // 39
    0xC0, 0xE0, 0xF0, 0xF0, 0xF8, 0x38, 0x0C, 0x0C, 0x04, 0x04, 0x02, 0x03, 0x07, 0x0F, 0x1F, 0x1F, 0x3C, 0x30, 0x20, 0x40, 0x40, 0x40, // 40
    0x02, 0x04, 0x04, 0x04, 0x0C, 0x38, 0xF8, 0xF0, 0xF0, 0xE0, 0xC0, 0x40, 0x40, 0x20, 0x20, 0x30, 0x3C, 0x1F, 0x1F, 0x0F, 0x07, 0x03, // 41
    0x20, 0xA0, 0xE0, 0x7C, 0xE0, 0x20, 0x20, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, // 42
    0xC0, 0xC0, 0xC0, 0xF8, 0xF8, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x5C, 0x7C, 0x3C, 0x18, // 44
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, // 45
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x1C, 0x1C, 0x08, // 46
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xE0, 0x38, 0x1C, 0x04, 0x40, 0x60, 0x70, 0x18, 0x0E, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, // 47
    0xC0, 0xE0, 0xF0, 0xF8, 0xF8, 0xF8, 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1C, 0xFC, 0xF8, 0xF8, 0xF0, 0xE0, 0xC0, 0x01, 0x07, 0x07, 0x0F, 0x0F, 0x1F, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1F, 0x0F, 0x0F, 0x07, 0x03, 0x01, // 48
    0x04, 0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x10, 0x10, // 49
    0x30, 0x78, 0x78, 0x78, 0x7C, 0x9C, 0x0C, 0x0C, 0x0C, 0x8C, 0xDC, 0xFC, 0xFC, 0xF8, 0xF8, 0x78, 0x70, 0x10, 0x18, 0x18, 0x1C, 0x1E, 0x1E, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x18, 0x18, 0x1C, 0x1E, 0x1F, // 50
    0x00, 0x10, 0x38, 0x38, 0x3C, 0x0C, 0x0C, 0xCC, 0xCC, 0xCC, 0xCC, 0xFC, 0xFC, 0x78, 0x78, 0x78, 0x30, 0x06, 0x0F, 0x0F, 0x0F, 0x1F, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x06, // 51
    0x80, 0x80, 0xC0, 0xC0, 0xE0, 0x60, 0x70, 0x30, 0x18, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x13, 0x13, 0x13, 0x1B, 0x1B, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1B, 0x1B, 0x13, 0x11, // 52
    0x00, 0x00, 0x78, 0x7C, 0xFC, 0xCC, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0xEC, 0xEC, 0xEC, 0xCC, 0xC4, 0x84, 0x00, 0x06, 0x0F, 0x0F, 0x0F, 0x1F, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1F, 0x0F, 0x0F, 0x0F, 0x07, 0x03, // 53
    0xC0, 0xE0, 0xF0, 0xF8, 0xF8, 0xF8, 0xBC, 0x8C, 0xCC, 0xCC, 0xCC, 0xCC, 0xDC, 0xDC, 0xD8, 0x98, 0x98, 0x80, 0x00, 0x03, 0x07, 0x07, 0x0F, 0x0F, 0x1F, 0x1D, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1D, 0x1F, 0x1F, 0x0F, 0x0F, 0x07, 0x07, // 54
    0x7C, 0x3C, 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x8C, 0xCC, 0xEC, 0xFC, 0x7C, 0x1C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1C, 0x1F, 0x1F, 0x1F, 0x1F, 0x11, 0x00, 0x00, 0x00, // 55
    0x70, 0xF8, 0xF8, 0xF8, 0xEC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xFC, 0xF8, 0xB8, 0x90, 0x00, 0x06, 0x0E, 0x0F, 0x0F, 0x1D, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1F, 0x0F, 0x0F, 0x07, 0x07, // 56
    0x70, 0xF0, 0xF8, 0xF8, 0xFC, 0xFC, 0xFC, 0xDC, 0x8C, 0x8C, 0x8C, 0x8C, 0xDC, 0xFC, 0xF8, 0xF8, 0xF0, 0xF0, 0xE0, 0x00, 0x00, 0x0C, 0x0C, 0x0D, 0x1D, 0x1D, 0x19, 0x19, 0x19, 0x19, 0x18, 0x1E, 0x0F, 0x0F, 0x0F, 0x07, 0x03, 0x01, // 57
    0x40, 0xE0, 0xE0, 0xE0, 0x40, 0x08, 0x1C, 0x1C, 0x1C, 0x08, // 58
    0x20, 0x70, 0x70, 0x70, 0x20, 0x00, 0x00, 0x58, 0x5C, 0x7C, 0x3C, 0x18, // 59
    0xE0, 0xE0, 0xF0, 0x78, 0x38, 0x3C, 0x01, 0x03, 0x07, 0x07, 0x0F, 0x1E, // 60
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, // 61
    0x3C, 0x38, 0x78, 0xF0, 0xE0, 0xE0, 0x1E, 0x0F, 0x07, 0x07, 0x03, 0x01, // 62
    0x18, 0x38, 0x3C, 0x3C, 0x4C, 0x0C, 0x8C, 0xCC, 0xFC, 0x78, 0x78, 0x30, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x1D, 0x1C, 0x08, 0x00, 0x00, 0x00, // 63
    0xE0, 0x10, 0xC8, 0xC4, 0x64, 0x24, 0xE4, 0xE8, 0x18, 0xF0, 0x03, 0x04, 0x09, 0x13, 0x12, 0x13, 0x13, 0x12, 0x09, 0x04, // 64
    0x00, 0x00, 0x00, 0x00, 0x84, 0xC4, 0xFC, 0xFC, 0x3C, 0x3C, 0x7C, 0xFC, 0xFC, 0xFC, 0xFC, 0xC4, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x1C, 0x1F, 0x1F, 0x1F, 0x1B, 0x13, 0x13, 0x13, 0x13, 0x13, 0x1B, 0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1C, 0x18, 0x10, 0x10, // 65
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0xFC, 0xFC, 0xFC, 0x7C, 0x78, 0x30, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, // 66
    0xC0, 0xE0, 0xF0, 0xF0, 0xF8, 0xF8, 0xFC, 0x3C, 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x18, 0x38, 0x7C, 0x00, 0x01, 0x03, 0x07, 0x0F, 0x0F, 0x0F, 0x1F, 0x1E, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x0C, 0x06, 0x03, // 67
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1C, 0x3C, 0xFC, 0xFC, 0xF8, 0xF8, 0xF0, 0xE0, 0xC0, 0x10, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1F, 0x1F, 0x0F, 0x0F, 0x07, 0x07, 0x03, // 68
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xEC, 0xEC, 0x0C, 0x1C, 0x1C, 0xFC, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, 0x19, 0x1B, 0x18, 0x1C, 0x1E, 0x1F, // 69
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xEC, 0xEC, 0x0C, 0x1C, 0x3C, 0x7C, 0x10, 0x10, 0x18, 0x1C, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1C, 0x18, 0x10, 0x10, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, // 70
    0xC0, 0xE0, 0xF0, 0xF0, 0xF8, 0xF8, 0x3C, 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1C, 0x18, 0x38, 0x38, 0x7C, 0x00, 0x00, 0x00, 0x01, 0x07, 0x07, 0x0F, 0x0F, 0x0F, 0x1E, 0x1C, 0x18, 0x18, 0x19, 0x19, 0x1B, 0x1B, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x03, 0x01, 0x01, // 71
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xCC, 0xC4, 0xC4, 0xC4, 0xC4, 0xCC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x04, 0x04, 0x10, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x19, 0x11, 0x11, 0x11, 0x11, 0x19, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, 0x10, 0x10, // 72
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x04, 0x04, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x10, 0x10, // 73
    0x00, 0x00, 0x00, 0x00, 0x84, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x04, 0x04, 0x07, 0x0F, 0x0F, 0x1F, 0x1C, 0x18, 0x18, 0x18, 0x1F, 0x1F, 0x0F, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, // 74
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0x84, 0xC4, 0xC4, 0xE4, 0xFC, 0xFC, 0xFC, 0xBC, 0x1C, 0x0C, 0x0C, 0x04, 0x04, 0x04, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1B, 0x11, 0x11, 0x10, 0x10, 0x1B, 0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1C, 0x18, 0x10, 0x10, // 75
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x10, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1E, 0x1F, 0x1F, // 76
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0x1C, 0x7C, 0xFC, 0xFC, 0xF8, 0xE0, 0xC0, 0xF0, 0xFC, 0x7C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x04, 0x04, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x11, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x11, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x10, 0x10, // 77
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0x7C, 0xFC, 0xFC, 0xF8, 0xF0, 0xE4, 0xC4, 0x8C, 0x8C, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x04, 0x04, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x11, 0x13, 0x07, 0x0F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, // 78
    0xC0, 0xE0, 0xF0, 0xF8, 0xF8, 0xF8, 0x3C, 0x1C, 0x0C, 0x0C, 0x0C, 0x1C, 0x3C, 0xFC, 0xF8, 0xF8, 0xF8, 0xF0, 0xE0, 0xC0, 0x01, 0x03, 0x07, 0x0F, 0x0F, 0x0F, 0x1E, 0x1C, 0x18, 0x18, 0x18, 0x1C, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x07, 0x03, 0x01, // 79
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0xFC, 0xFC, 0xF8, 0xF8, 0xF8, 0x70, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x19, 0x19, 0x11, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, // 80
    0xC0, 0xE0, 0xF0, 0xF0, 0xF8, 0xF8, 0xFC, 0x3C, 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1C, 0x3C, 0xF8, 0xF8, 0xF0, 0xF0, 0xE0, 0xC0, 0x03, 0x07, 0x0F, 0x0F, 0x0F, 0x1F, 0x1F, 0x1C, 0x1E, 0x39, 0xF9, 0xFF, 0xFE, 0xF8, 0xDC, 0xDF, 0x9F, 0x8F, 0x0F, 0x07, 0x03, // 81
    0x04, 0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0xFC, 0xFC, 0xFC, 0xF8, 0x78, 0x70, 0x00, 0x00, 0x10, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x19, 0x11, 0x11, 0x11, 0x01, 0x07, 0x1F, 0x1F, 0x1F, 0x1E, 0x1C, 0x18, 0x10, 0x10, // 82
    0x78, 0x7C, 0xFC, 0xFE, 0xF6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xEC, 0xEC, 0xFC, 0xDC, 0xFC, 0x80, 0x00, 0x00, 0x1F, 0x1E, 0x0C, 0x0D, 0x1D, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1F, 0x0F, 0x0F, 0x07, // 83
    0x40, 0x3C, 0x3C, 0x1C, 0x0C, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x0C, 0x1C, 0x3C, 0x3C, 0x40, 0x00, 0x00, 0x00, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, // 84
    0x04, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x07, 0x07, 0x0F, 0x0F, 0x1F, 0x1F, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x0F, 0x0F, 0x07, 0x00, 0x00, 0x00, // 85
    0x04, 0x0C, 0x0C, 0x1C, 0x7C, 0xFC, 0xFC, 0xFC, 0xFC, 0xEC, 0xC4, 0x04, 0x00, 0x04, 0xC4, 0xEC, 0xFC, 0x7C, 0x1C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x13, 0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1F, 0x1F, 0x1B, 0x11, 0x10, 0x00, 0x00, 0x00, // 86
    0x04, 0x0C, 0x1C, 0x7C, 0xFC, 0xFC, 0xFC, 0xEC, 0xC4, 0x04, 0x84, 0xE4, 0xFC, 0xFC, 0x3C, 0xFC, 0xFC, 0xFC, 0xF4, 0xC4, 0x84, 0x84, 0xE4, 0xFC, 0xFC, 0x3C, 0x0C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1B, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1B, 0x10, 0x00, 0x10, 0x1B, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, // 87
    0x04, 0x04, 0x0C, 0x0C, 0x1C, 0x3C, 0x3C, 0x7C, 0xFC, 0xFC, 0xF4, 0xE4, 0xE4, 0xF4, 0xFC, 0x3C, 0x3C, 0x1C, 0x0C, 0x0C, 0x04, 0x04, 0x00, 0x10, 0x10, 0x10, 0x18, 0x1C, 0x1C, 0x1E, 0x1F, 0x17, 0x13, 0x13, 0x13, 0x17, 0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1C, 0x18, 0x18, 0x10, 0x10, // 88
    0x04, 0x04, 0x0C, 0x0C, 0x1C, 0x3C, 0x7C, 0xFC, 0xFC, 0xFC, 0xE4, 0xC4, 0xC4, 0xE4, 0x7C, 0x3C, 0x1C, 0x0C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x18, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, // 89
    0x00, 0x00, 0x7C, 0x3C, 0x1C, 0x0C, 0x8C, 0x8C, 0xCC, 0xEC, 0xFC, 0xFC, 0xFC, 0x7C, 0x7C, 0x3C, 0x1C, 0x0C, 0x84, 0x10, 0x10, 0x18, 0x1C, 0x1E, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1B, 0x19, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1F, 0x1F, // 90
    0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x04, 0x7F, 0x7F, 0x7F, 0x7F, 0x40, 0x40, // 91
    0x04, 0x0C, 0x1C, 0x30, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x0E, 0x38, 0x70, 0x40, // 92
    0x04, 0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x40, 0x40, 0x7F, 0x7F, 0x7F, 0x7F, // 93
    0x80, 0xF0, 0xFC, 0x3C, 0x3C, 0xFC, 0xF0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, // 95
    0x02, 0x02, 0x06, 0x06, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 96
    0xC0, 0xC0, 0xE0, 0xE0, 0x60, 0x60, 0x60, 0x60, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x0C, 0x1E, 0x1E, 0x1E, 0x1A, 0x1B, 0x1B, 0x09, 0x0F, 0x1F, 0x1F, 0x1F, 0x18, 0x0C, // 97
    0x04, 0x04, 0xFC, 0xFC, 0xFC, 0xFE, 0xC0, 0x60, 0x60, 0x60, 0xE0, 0xE0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x1F, 0x0F, 0x07, 0x0F, 0x1C, 0x18, 0x18, 0x1C, 0x1F, 0x1F, 0x0F, 0x0F, 0x07, // 98
    0x00, 0x80, 0xC0, 0xC0, 0xE0, 0x60, 0x20, 0x20, 0x20, 0x60, 0xE0, 0xC0, 0xC0, 0x00, 0x07, 0x07, 0x0F, 0x0F, 0x1F, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x06, // 99
    0x80, 0xC0, 0xC0, 0xE0, 0xE0, 0xE4, 0x64, 0x64, 0xC4, 0xFC, 0xFC, 0xFC, 0xFE, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x0F, 0x1F, 0x1F, 0x18, 0x18, 0x18, 0x0C, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, 0x10, // 100
    0x00, 0x80, 0xC0, 0xC0, 0xE0, 0xE0, 0x20, 0x20, 0x20, 0x60, 0xC0, 0xC0, 0x80, 0x00, 0x07, 0x0F, 0x0F, 0x0F, 0x1F, 0x1E, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x0B, 0x0A, // 101
    0x40, 0x60, 0x60, 0xF8, 0xFC, 0xFE, 0xFE, 0xFE, 0x62, 0x62, 0x6E, 0x0E, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, 0x10, 0x10, // 102
    0x00, 0x80, 0xC0, 0xC0, 0xE0, 0x20, 0x20, 0x20, 0x20, 0xE0, 0xE0, 0xC0, 0xF0, 0x50, 0x30, 0x40, 0x7C, 0xFF, 0xD9, 0x99, 0x9A, 0x9A, 0x9E, 0x9E, 0x9F, 0x9F, 0x9D, 0xFD, 0x78, 0x30, // 103
    0x04, 0x04, 0x04, 0xFC, 0xFC, 0xFC, 0xFE, 0xC0, 0x40, 0x60, 0x60, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, // 104
    0x20, 0x20, 0x60, 0xE8, 0xFC, 0xFC, 0xFC, 0x08, 0x00, 0x00, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, 0x10, // 105
    0x20, 0x20, 0x20, 0x68, 0xFC, 0xFC, 0xFC, 0xE8, 0xE0, 0xE0, 0xE0, 0xC0, 0xFF, 0xFF, 0x7F, 0x7F, // 106
    0x04, 0x04, 0x04, 0xFC, 0xFC, 0xFC, 0xFE, 0x00, 0x20, 0xA0, 0xE0, 0xE0, 0xE0, 0xE0, 0x60, 0x60, 0x20, 0x20, 0x20, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x16, 0x13, 0x13, 0x17, 0x1F, 0x1F, 0x1F, 0x1E, 0x1C, 0x18, 0x10, 0x10, // 107
    0x04, 0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0xFE, 0x00, 0x00, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, // 108
    0x20, 0x20, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0x80, 0x40, 0x60, 0x60, 0xE0, 0xE0, 0xE0, 0xC0, 0x80, 0xC0, 0x40, 0x60, 0x60, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, 0x10, // 109
    0x20, 0x20, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0x80, 0x40, 0x60, 0x60, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, // 110
    0x00, 0x80, 0xC0, 0xC0, 0xE0, 0xE0, 0x60, 0x60, 0x60, 0xE0, 0xE0, 0xC0, 0xC0, 0x80, 0x00, 0x03, 0x07, 0x0F, 0x0F, 0x1F, 0x1C, 0x18, 0x18, 0x18, 0x1C, 0x1F, 0x0F, 0x0F, 0x07, 0x07, // 111
    0x20, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0x60, 0x60, 0x60, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0x98, 0x98, 0x98, 0x1F, 0x1F, 0x0F, 0x0F, 0x07, // 112
    0x00, 0xC0, 0xC0, 0xE0, 0xE0, 0x60, 0x60, 0x60, 0xE0, 0xC0, 0xC0, 0xC0, 0xE0, 0x00, 0x00, 0x07, 0x0F, 0x0F, 0x1F, 0x1C, 0x18, 0x98, 0x98, 0x8C, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x80, // 113
    0x20, 0x20, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0x80, 0x40, 0x60, 0xE0, 0xE0, 0xE0, 0xC0, 0x10, 0x10, 0x18, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, 0x10, 0x11, 0x01, 0x01, 0x00, // 114
    0xC0, 0xC0, 0xE0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x20, 0x40, 0x60, 0xE0, 0x00, 0x1D, 0x1F, 0x1B, 0x1F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1F, 0x0F, 0x0E, // 115
    0x40, 0x60, 0xE0, 0xF0, 0xF8, 0xFC, 0x60, 0x60, 0x20, 0x00, 0x00, 0x00, 0x0F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x1A, 0x0C, // 116
    0x20, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x00, 0x20, 0x20, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x1F, 0x1F, 0x1F, 0x18, 0x18, 0x08, 0x0C, 0x1F, 0x1F, 0x1F, 0x1F, 0x18, 0x10, 0x10, // 117
    0x20, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x20, 0x00, 0x20, 0xE0, 0xE0, 0xE0, 0xE0, 0x60, 0x20, 0x00, 0x00, 0x00, 0x01, 0x13, 0x1F, 0x1F, 0x1F, 0x1E, 0x1C, 0x1E, 0x1F, 0x17, 0x11, 0x00, 0x00, 0x00, // 118
    0x20, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x20, 0x20, 0x20, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x20, 0x20, 0x20, 0x20, 0xE0, 0xE0, 0xE0, 0x60, 0x20, 0x00, 0x00, 0x00, 0x11, 0x17, 0x1F, 0x1F, 0x1F, 0x1C, 0x1F, 0x1F, 0x13, 0x01, 0x13, 0x1F, 0x1F, 0x1F, 0x1E, 0x1C, 0x1F, 0x17, 0x11, 0x00, 0x00, 0x00, // 119
    0x20, 0x20, 0x60, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0xA0, 0xA0, 0xA0, 0xA0, 0xE0, 0xE0, 0x60, 0x60, 0x20, 0x20, 0x00, 0x10, 0x10, 0x10, 0x18, 0x18, 0x1C, 0x1F, 0x17, 0x17, 0x17, 0x1F, 0x1F, 0x1F, 0x1C, 0x1C, 0x18, 0x10, 0x10, 0x10, // 120
    0x20, 0x60, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x20, 0x20, 0x20, 0x20, 0xE0, 0xE0, 0xE0, 0x60, 0x20, 0x00, 0x00, 0x40, 0xE0, 0xE1, 0xE3, 0xCF, 0xDF, 0xFF, 0x7E, 0x3E, 0x1F, 0x07, 0x03, 0x00, 0x00, 0x00, // 121
    0x00, 0xE0, 0x60, 0x20, 0x20, 0xA0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x60, 0x20, 0x11, 0x18, 0x1C, 0x1E, 0x1F, 0x1F, 0x1F, 0x1F, 0x1B, 0x19, 0x18, 0x18, 0x1C, 0x1F, // 122
    0x00, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x04, 0x04, 0x01, 0x7F, 0xFF, 0xFF, 0xFE, 0x80, 0x80, 0x80, // 123
    0xFC, 0xFC, 0xFC, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, // 124
    0x04, 0x04, 0x04, 0xFC, 0xFC, 0xFC, 0xF8, 0x00, 0x80, 0x80, 0x80, 0xFE, 0xFF, 0xFF, 0x7F, 0x01, // 125
    0x08, 0x0E, 0x07, 0x07, 0x0F, 0x0E, 0x0F, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFE, 0x02, 0x02, 0x02, 0xFE, 0x1F, 0x10, 0x10, 0x10, 0x1F // 127
    
};

#endif
