#include "mbed.h"
#include "capteur_laser.h"
#include "Servo.h"

Servo servo_laser(A3);
int dist_mesure[9];


#define GAIN_CONTOURNER 2
#define ALPHA0 20
/*
 * INPUT: d: le pointeur vers un tableau de 9 valeurs de distance
          dirR: la direction du Robot, recuperee par la boussole
 * OUTPUT: nouvelle_consigne: l'angle absolute pour contourner dse obstacles
 */

float contournement(int* d, float dirR)
{
    float k;
    float angle_tourner;
    float nouvelle_consigne;
    float somme_d = 0;
    float somme_d_k = 0;
    for(int i=0; i<9; i++)
    {
        k = i-4;
        somme_d += (float)d[i];
        somme_d_k += k*(float)d[i];
    }
    angle_tourner = (somme_d_k/somme_d)*ALPHA0*GAIN_CONTOURNER;
    if(angle_tourner>90) angle_tourner=90;
    if(angle_tourner<-90) angle_tourner=-90;
    nouvelle_consigne = angle_tourner + dirR;
    return nouvelle_consigne;
}

int main()
{
    float nouvelle_angle;
    laser_init();
    servo_laser.set_position(0);
    wait_ms(300);
    int i=0;
    
    for(int d=0;d<=180;d += 20)
    {
        servo_laser.set_position(d);
        wait_ms(100);
        dist_mesure[i] = laser_mesure(3);
        if(dist_mesure[i] > 1200) dist_mesure[i] = 1200;
        i++;
        //printf("Average is %d\n\r", ave);
    }
    printf("\n\n\r*******\n\r");
    for(i=0; i<9; i++)
    {
        printf("%d\n\r", dist_mesure[i]);
    }
    printf("\n\n\r*******\n\r");
    
    nouvelle_angle = contournement(dist_mesure, 0);
    printf("%.2f\n\r", nouvelle_angle);

    while (1)
    {
    }
}