#include "dot_util.h"
#include "RadioEvent.h"
#include "string.h"
#if ACTIVE_EXAMPLE == OTA_EXAMPLE

static std::string network_name = "MultiTech";
static std::string network_passphrase = "MultiTech";
static uint8_t network_id[] = { 0x6C, 0x4E, 0xEF, 0x66, 0xF4, 0x79, 0x86, 0xA6 };
static uint8_t network_key[] = { 0x1F, 0x33, 0xA1, 0x70, 0xA5, 0xF1, 0xFD, 0xA0, 0xAB, 0x69, 0x7A, 0xAE, 0x2B, 0x95, 0x91, 0x6B };
static uint8_t frequency_sub_band = 0;
static bool public_network = true;
static uint8_t join_delay = 5;
static uint8_t ack = 1;
static bool adr = true;

static bool deep_sleep = false;

mDot* dot = NULL;
lora::ChannelPlan* plan = NULL;

Serial pc(USBTX, USBRX);
    
char buffer_data[20];

int main() {
    // Custom event handler for automatically displaying RX data
    RadioEvent events;
    pc.baud(115200);
    
    int _array_Tx[7] = {2,5,8,11,14,17,20};
    //  Caution : at here convert position follow position of _array_Tx
    int _min_Tx = 3; // ~ Tx = 11 dBm = _array_Tx[3]
    int _max_Tx = 3; // ~ Tx = 11 dBm

    int _array_DR[8] = {0,1,2,3,4,5,6,7};
    int _min_DR = 2;
    int _max_DR = 2;
    wait(2);
    
    /////////////////////////////// function
 
    mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);
    
    #if CHANNEL_PLAN == CP_US915
        plan = new lora::ChannelPlan_US915();
    #elif CHANNEL_PLAN == CP_AS923
        plan = new lora::ChannelPlan_AS923();
    #endif
    assert(plan);

    dot = mDot::getInstance(plan);
    assert(dot);

    // attach the custom events handler
    dot->setEvents(&events);

    if (!dot->getStandbyFlag())
     {
        logInfo("mbed-os library version: %d", MBED_LIBRARY_VERSION);

        // start from a well-known state
        logInfo("defaulting Dot configuration");
        dot->resetConfig();
        dot->resetNetworkSession();

        // make sure library logging is turned on
        dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

        // update configuration if necessary
        if (dot->getJoinMode() != mDot::OTA) 
        {
            logInfo("changing network join mode to OTA");
            if (dot->setJoinMode(mDot::OTA) != mDot::MDOT_OK) 
            {
                logError("failed to set network join mode to OTA");
            }
        }
        // in OTA and AUTO_OTA join modes, the credentials can be passed to the library as a name and passphrase or an ID and KEY
        // only one method or the other should be used!
        // network ID = crc64(network name)
        // network KEY = cmac(network passphrase)
        update_ota_config_name_phrase(network_name, network_passphrase, frequency_sub_band, public_network, ack);
        //update_ota_config_id_key(network_id, network_key, frequency_sub_band, public_network, ack);

        // configure network link checks
        // network link checks are a good alternative to requiring the gateway to ACK every packet and should allow a single gateway to handle more Dots
        // check the link every count packets
        // declare the Dot disconnected after threshold failed link checks
        // for count = 3 and threshold = 5, the Dot will ask for a link check response every 5 packets and will consider the connection lost if it fails to receive 3 responses in a row
        update_network_link_check_config(3, 5);

        // enable or disable Adaptive Data Rate
       // dot->setAdr(adr);
       // dot->setTxDataRate(2);
      
       // dot->setTxPower(5);
       // logInfo(" du lieu TxPower %u",dot->getTxPower());
        // Configure the join delay
        dot->setJoinDelay(join_delay);

        // save changes to configuration
        logInfo("saving configuration");
        if (!dot->saveConfig()) {
            logError("failed to save configuration");
        }
        // display configuration
        display_config();
    } 
    else 
    {
        // restore the saved session if the dot woke from deepsleep mode
        // useful to use with deepsleep because session info is otherwise lost when the dot enters deepsleep
        logInfo("restoring network session from NVM");
        dot->restoreNetworkSession();
    }
    /////////////////////////////////////////// end function

    while(true)   // intial infinite loop from here
    {
        int _value_loop = 10;
             
        pc.printf(" START begin now -  please press button OPEN on APP SERIAL to BEGIN --- ");
        // fix at here
        while (_value_loop)
        {
        
        pc.scanf("%s",&buffer_data);
        pc.printf(" DATA received %s \n ", buffer_data);
        if(buffer_data[0] == 'T' && buffer_data[1] =='x' && buffer_data[6] =='P')
            {
                _value_loop = 0; 
                break;
            }
        }
        
        // check string config  TxDR00PWR11TO17OK
        if(buffer_data[0] != 'T' && buffer_data[1] !='x' && buffer_data[6] !='P')
        return 0;
         
        // process string config 
        int _array_get_config[6] ={0,0,0,0,0,0};
        int _count_config = 0;
        for(int run = 0; run < sizeof(buffer_data); run++)
        {
            if( buffer_data[run] >='0' && buffer_data[run] <= '9') 
            {
                _array_get_config[_count_config] = int (buffer_data[run] -48);
                _count_config ++;
            }            
        }
        
        wait(2);
        // set DR and Tx
        pc.printf(" Get value Done \n ");
        _min_DR = _array_get_config[0];
        _max_DR = _array_get_config[1];
        _min_Tx = _array_get_config[2];
        _max_Tx = _array_get_config[3];
        // wait for stable
        wait(5);
    
        // function   mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);    ===>>  dot->restoreNetworkSession();
    
        int _count_while = 1;
        while (_count_while-- >0) 
        {
            std::vector<uint8_t> tx_data;
            tx_data.clear();
            tx_data.push_back(0x1D);
            tx_data.push_back(0x1A);
            tx_data.push_back(0x1B);
            tx_data.push_back(0xBB);
            tx_data.push_back(0xCC);
            tx_data.push_back(0xDD);
            tx_data.push_back(0xEE);
            tx_data.push_back(0xFF);
            tx_data.push_back(0x1D);
            
            // join network if not joined 
            
           for(int x = _min_Tx ; x <= _max_Tx ; x++)
           {
                
                //dot->setTxPower(_array_Tx[x]);
                if (dot->setTxPower(_array_Tx[x]) != mDot::MDOT_OK) {
                logError("failed to set TX power to %u", _array_Tx[x]);
                }
                else{
                    logInfo("\n Data with POWER TRANSMITION %d ============= TESTING ==== \n",_array_Tx[x]);
                }
                wait(3);
        
                for(int i = _min_DR; i <= _max_DR ; i++)
                {
                    
                    //dot->setTxDataRate(_array_DR[i]);
                    if (dot->setTxDataRate(_array_DR[i]) != mDot::MDOT_OK) {
                        logError("failed to set TX datarate to %u", _array_DR[i]);
                        }
                        else{
                            logInfo(" === Data with DR %d ============= TESTING == \n",i);
                        }
                
                    if (!dot->getNetworkJoinStatus()) 
                    {
                        join_network();
                    }
            
                    for(int i = 0; i <3; i++ )
                    {
                        
                        send_data(tx_data);
                        wait(3);
                        pc.printf(" SENDING data test ========== \n");
                        pc.printf(" RSSI =%d and SNR =%d >>>> OK Done \n",(dot->getRssiStats()).last,(dot->getSnrStats()).last);
                    }
        
                  }
              }//for
            
            }       
            
        logInfo("\n Data with POWER TRANSMITION %u DR ; va %u PWR \n",dot->getTxDataRate(),dot->getTxPower());    
        pc.printf("@@@@@@@@@@ THE END test signal @@@@@@@@@@@@@@@@@@@@@@@@ \n \n \n ");
    
        buffer_data[0] ='N';
        buffer_data[1] ='A';
        _value_loop = 10;

      } // end from infinite loop
    //return 0;
}

#endif
