//
// RadarTimer.cpp - Radar time subsystem simulator.
//

#include "RadarTimer.h"
#include "Commons.h"

RadarTimer::RadarTimer()
{
    // Set 10seconds as default value for scan period;
    _scanPeriod = 10000;
    _lastScanTime = 0;
}

RadarTimer::RadarTimer(uint32_t scanPeriod)
{
    SetScanPeriod(scanPeriod);
    _lastScanTime = 0;
}


void RadarTimer::SetScanPeriod(uint32_t scanPeriod)
{
    _scanPeriod = scanPeriod * 1000;
}

void RadarTimer::Start()
{
#ifndef _SDL_timer_h
    start();
#endif
    _lastScanTime = GetRunningTime();
}


uint32_t RadarTimer::GetRunningTime()
{
#ifdef _SDL_timer_h
    return SDL_GetTicks();
#else
    return read_ms();
#endif
}


void RadarTimer::RegisterScan()
{
    // Lock scan time
    _runningTime = GetRunningTime();

    // Reset scan time after one full turn
    if (_runningTime >= (_lastScanTime + _scanPeriod)) {
        _lastScanTime = _runningTime;
    }
}


float RadarTimer::GetBeamAngle()
{
    float angle = 2 * M_PI * (GetRunningTime() - _lastScanTime) / (float)_scanPeriod;
    if(angle >= (2 * M_PI)) {
        angle -= 2 * M_PI;
    }

    return angle;
}