/*
    RadarTimer.h - Radar time subsystem simulator, inherits timer and implements beam angle calculation method.

    Copyright(c) 2016 karpent at gmail.com, MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the "Software"),
    to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :

    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
    THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/ 


#include "mbed.h"

/**
  * @brief Radar time subsystem simulator, inherits timer and implements beam angle calculation method.
  */
class RadarTimer : public Timer
{
public:
    RadarTimer();

    /**
      * @brief Sets scan period in seconds
      */    
    RadarTimer(uint32_t scanPeriod);

    /**
      * @brief Sets scan period in seconds
      */    
    void SetScanPeriod(uint32_t scanPeriod);
 
     /**
      * @brief Starts the timer
      */    
    void Start();
 
    void RegisterScan();
       
    /**
      * @brief Get current time in miliseconds
      */
    uint32_t GetRunningTime();

    /**
      * @brief Get current beam angle in radians
      */
    float GetBeamAngle();
    
private:
    /// <summary>
    /// The radar scan period in milisecons.
    /// </summary>
    uint32_t _scanPeriod;
    
    uint32_t _lastScanTime;
    
    uint32_t _runningTime;
};