/*
    TouchScreen.h - Touchscreen

    Copyright(c) 2016 karpent at gmail.com, MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the "Software"),
    to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :

    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
    THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#pragma once

#include "TS_DISCO_F746NG.h"
#include "RK043FN48H.h"

/// <summary>
/// Touchscreen class
/// </summary>
class TouchScreen : public TS_DISCO_F746NG
{
public:
    /// <summary>
    /// Initializes a new instance of the <see cref="TouchScreen"/> class.
    /// </summary>
    TouchScreen(Display* display);

    /// <summary>
    /// Finalizes an instance of the <see cref="TouchScreen"/> class.
    /// </summary>
    ~TouchScreen();
    
  /**
    * @brief  Initializes and configures the touch screen functionalities and 
    *         configures all necessary hardware resources (GPIOs, I2C, clocks..).
    */
    void Init();
         
    /// <summary>
    /// Detect a touch.
    /// Returns a pointer to tpoch point position or NULL if touch was not detected. 
    /// </summary>
    pPoint DetectTouch();
    
    Point touchPoint;
    
private:
    /// Maximum X size of the TS area on LCD
    uint16_t _width;
    
    /// Maximum Y size of the TS area on LCD
    uint16_t _height;
    
    TS_StateTypeDef tsState;
};

