//
// RK043FN48H.h - DISCO_F746NG display
//

#include "RK043FN48H.h"

static Layer _selectedLayer = Foreground;

RK043FN48H::RK043FN48H()
{
    BSP_LCD_Init();

    FbBackgroundStartAdress = LCD_FB_START_ADDRESS;
    FbForegroundStartAdress = LCD_FB_START_ADDRESS+(BSP_LCD_GetXSize()*BSP_LCD_GetYSize()*4);

    BSP_LCD_LayerDefaultInit(0, FbBackgroundStartAdress);
    BSP_LCD_LayerDefaultInit(1, FbForegroundStartAdress);

    BSP_LCD_DisplayOn();

    actualDrawProp[0].TextColor = LCD_COLOR_WHITE;
    actualDrawProp[0].BackColor = LCD_COLOR_BLACK;
    actualDrawProp[0].pFont = &Font16; // &LCD_DEFAULT_FONT
    //_selectedFont[0] = GrFont(Courier16);

    actualDrawProp[1].TextColor = LCD_COLOR_WHITE & ALPHA_MASK;
    actualDrawProp[1].BackColor = LCD_COLOR_BLACK & ALPHA_MASK;
    actualDrawProp[1].pFont = &Font16; // &LCD_DEFAULT_FONT
    //_selectedFont[1] = GrFont(Courier16);

    // Initialize layer 0 properties
    SetActiveLayer(Background);
    SetBackgroundColor(actualDrawProp[0].BackColor);
    Clear();
    SetForegroundColor(actualDrawProp[0].TextColor);
    BSP_LCD_SetFont(&Font16);

    // Initialize layer 1 properties
    SetActiveLayer(Foreground);
    SetBackgroundColor(actualDrawProp[1].BackColor);
    Clear();
    SetForegroundColor(actualDrawProp[1].TextColor);
    BSP_LCD_SetFont(&Font16);

    // Set layers transparency
    SetLayersTransparency(0xFF, 0xFF);
    SetLayersVisibility(true, true);

/*
    _cursorPos[Background].X = 0;
    _cursorPos[Background].Y = 0;
    _cursorPos[Foreground].X = 0;
    _cursorPos[Foreground].Y = 0;
*/
}


RK043FN48H::~RK043FN48H()
{
    BSP_LCD_DeInit();
}


void RK043FN48H::Clear()
{
    BSP_LCD_Clear(actualDrawProp[_selectedLayer].BackColor);
}


void RK043FN48H::Clear(uint32_t color)
{
    BSP_LCD_Clear(color);
}


void RK043FN48H::ClearLayer(Layer layer, uint32_t color)
{
    Layer oldLayer = GetActiveLayer();

    SetActiveLayer(layer);
    Clear(color);
    SetActiveLayer(oldLayer);
}


void RK043FN48H::SetBackgroundColor(uint32_t color)
{
    actualDrawProp[_selectedLayer].BackColor = color;
    BSP_LCD_SetBackColor(actualDrawProp[_selectedLayer].BackColor);
}


void RK043FN48H::SetForegroundColor(uint32_t color)
{
    actualDrawProp[_selectedLayer].TextColor = color;
    BSP_LCD_SetTextColor(actualDrawProp[_selectedLayer].TextColor);
}


void RK043FN48H::SetDrawColor(uint8_t red, uint8_t green, uint8_t blue, uint8_t alpha)
{
    // Calculate display pixel value for selected color
    uint32_t color = red << 16 | green << 8 | blue | alpha << 24;
    SetForegroundColor(color);
}

uint32_t RK043FN48H::GetDrawColor()
{
    return actualDrawProp[_selectedLayer].TextColor;
}


void RK043FN48H::DrawPoint(int posX, int posY, uint32_t colorMask)
{
    if( posX >= 0 && posX < DisplayWidth() && posY >=0 && posY < DisplayHeight()) {
        BSP_LCD_DrawPixel(posX, posY, colorMask);
    }
}


//void RK043FN48H::DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2)
//{
//    BSP_LCD_DrawLine(x1, y1, x2, y2);
//}


void RK043FN48H::CopyBitmap(Layer layer, uint8_t * bitmap, uint32_t width, uint32_t height, uint32_t rgbGolorCode)
{
    // Check size
    if(width > DisplayWidth() || height > DisplayHeight())
        return;
    
    ClearLayer(layer, 0x00000000);

    uint16_t maxCol = width / 8;   // 60 columns
    if ((width % 8) != 0)
    {
        maxCol++;
    }
    
    for (int y = 0; y < height; y++) {
        for (int col = 0; col < maxCol; col++) {
            uint8_t shift = bitmap[y*maxCol + col];
            for (int pos = 0; pos < 8; pos++) {
                int x = (col << 3) + pos;   // x = col * 8 + pos
                if (x >= width)
                    break;

                if(shift & 1 << pos)
                {
                    DrawPoint(x, y, rgbGolorCode);
                }
            }
        }
    }
}


uint16_t RK043FN48H::DisplayWidth()
{
    return BSP_LCD_GetXSize();
}


uint16_t RK043FN48H::DisplayHeight()
{
    return BSP_LCD_GetYSize();
}


void RK043FN48H::SetActiveLayer(Layer layer)
{
    _selectedLayer = layer;
    
    BSP_LCD_SelectLayer((uint32_t)layer);
}


Layer RK043FN48H::GetActiveLayer()
{
    return _selectedLayer;
}


void RK043FN48H::SetLayersTransparency( uint8_t background, uint8_t foreground)
{
    BSP_LCD_SetTransparency(0, background);
    BSP_LCD_SetTransparency(1, foreground);
}


void RK043FN48H::SetLayersVisibility( bool background, bool foreground)
{
    BSP_LCD_SetLayerVisible(0, background ? ENABLE : DISABLE);
    BSP_LCD_SetLayerVisible(1, foreground ? ENABLE : DISABLE);
}



//New Function
//Add date: 25/08/2019

void RK043FN48H::DrawHLine(uint16_t Xpos, uint16_t Ypos, uint16_t Length)
{
  BSP_LCD_DrawHLine(Xpos, Ypos, Length);
}

void RK043FN48H::DrawVLine(uint16_t Xpos, uint16_t Ypos, uint16_t Length)
{
  BSP_LCD_DrawVLine(Xpos, Ypos, Length);
}

void RK043FN48H::DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2)
{
  BSP_LCD_DrawLine(x1, y1, x2, y2);
}

void RK043FN48H::DrawRect(uint16_t Xpos, uint16_t Ypos, uint16_t Width, uint16_t Height)
{
  BSP_LCD_DrawRect(Xpos, Ypos, Width, Height);
}

void RK043FN48H::DrawCircle(uint16_t Xpos, uint16_t Ypos, uint16_t Radius)
{
  BSP_LCD_DrawCircle(Xpos, Ypos, Radius);
}

void RK043FN48H::DrawPolygon(pPoint Points, uint16_t PointCount)
{
  BSP_LCD_DrawPolygon(Points, PointCount);
}

void RK043FN48H::DrawEllipse(int Xpos, int Ypos, int XRadius, int YRadius)
{
  BSP_LCD_DrawEllipse(Xpos, Ypos, XRadius, YRadius);
}

void RK043FN48H::DrawBitmap(uint32_t Xpos, uint32_t Ypos, uint8_t *pbmp)
{
  BSP_LCD_DrawBitmap(Xpos, Ypos, pbmp);
}

void RK043FN48H::FillRect(uint16_t Xpos, uint16_t Ypos, uint16_t Width, uint16_t Height)
{
  BSP_LCD_FillRect(Xpos, Ypos, Width, Height);
}

void RK043FN48H::FillCircle(uint16_t Xpos, uint16_t Ypos, uint16_t Radius)
{
  BSP_LCD_FillCircle(Xpos, Ypos, Radius);
}

void RK043FN48H::FillPolygon(pPoint Points, uint16_t PointCount)
{
  BSP_LCD_FillPolygon(Points, PointCount);
}

void RK043FN48H::FillEllipse(int Xpos, int Ypos, int XRadius, int YRadius)
{
  BSP_LCD_FillEllipse(Xpos, Ypos, XRadius, YRadius);
}

void RK043FN48H::SetTextColor(uint32_t Color)
{
  BSP_LCD_SetTextColor(Color);
}

uint32_t RK043FN48H::GetTextColor(void)
{
  return BSP_LCD_GetTextColor();
}

void RK043FN48H::SetBackColor(uint32_t Color)
{
  BSP_LCD_SetBackColor(Color);
}

uint32_t RK043FN48H::GetBackColor(void)
{
  return BSP_LCD_GetBackColor();
}

void RK043FN48H::SetFont(sFONT *fonts)
{
  BSP_LCD_SetFont(fonts);
}

sFONT *RK043FN48H::GetFont(void)
{
  return BSP_LCD_GetFont();
}

uint32_t RK043FN48H::ReadPixel(uint16_t Xpos, uint16_t Ypos)
{
  return BSP_LCD_ReadPixel(Xpos, Ypos);
}

void RK043FN48H::DrawPixel(uint16_t Xpos, uint16_t Ypos, uint32_t pixel)
{
  BSP_LCD_DrawPixel(Xpos, Ypos, pixel);
}


void RK043FN48H::ClearStringLine(uint32_t Line)
{
  BSP_LCD_ClearStringLine(Line);
}

void RK043FN48H::DisplayStringAtLine(uint16_t Line, uint8_t *ptr)
{
  BSP_LCD_DisplayStringAtLine(Line, ptr);
}

void RK043FN48H::DisplayStringAt(uint16_t Xpos, uint16_t Ypos, uint8_t *Text, Text_AlignModeTypdef Mode)
{
  BSP_LCD_DisplayStringAt(Xpos, Ypos, Text, Mode);
}

void RK043FN48H::DisplayChar(uint16_t Xpos, uint16_t Ypos, uint8_t Ascii)
{
  BSP_LCD_DisplayChar(Xpos, Ypos, Ascii);
}

