/*
    DisplayBase.h - Graphics display base class declaration

    Copyright(c) 2016 karpent at gmail.com, MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the "Software"), 
    to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
    and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :

    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR 
    THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#pragma once

#include "stdint.h" // for uint32_t, uint16_t, uint8_t;

/// <summary>
/// Graphics display abstract base class
/// </summary>
class DisplayBase
{
public:
    /// <summary>
    /// Returns screen width.
    /// </summary>
    /// <returns></returns>
    uint16_t virtual DisplayWidth() = 0;

    /// <summary>
    /// Redurns screen height.
    /// </summary>
    /// <returns></returns>
    uint16_t virtual DisplayHeight() = 0;

    /// <summary>
    /// Sets the color of the draw.
    /// </summary>
    /// <param name="red">The red.</param>
    /// <param name="green">The green.</param>
    /// <param name="blue">The blue.</param>
    /// <param name="alpha">The alpha.</param>
    void virtual SetDrawColor(uint8_t red, uint8_t green, uint8_t blue, uint8_t alpha) = 0;
};

