//
// Canvas.cpp - Simple canvas.
//

#include "Canvas.h"
#include "stdlib.h"

Canvas::Canvas(void)
{
    Reset();
}


Canvas::Canvas(uint16_t width, uint16_t height)
{
    SetSize(width, height);
}


Canvas::~Canvas()
{
    free(_planeBitmap);
}


void Canvas::Reset()
{
    _width = 0;
    _height = 0;

    _planeBitmap = (uint8_t *)NULL;
    _planeBitmapSize = 0;
}


uint16_t Canvas::DisplayWidth()
{
    return _width;
}


uint16_t Canvas::DisplayHeight()
{
    return _height;
}

void Canvas::DrawPoint(int posX, int posY, uint32_t colorMask)
{
    if ((posX >= 0) && (posX < DisplayWidth()) && (posY >= 0) && (posY < DisplayHeight())) {

        uint32_t shift = posX % PLANE_BITMAP_ELEMENT_BITS;
        uint32_t col = posX / PLANE_BITMAP_ELEMENT_BITS;

        uint32_t colsNum = DisplayWidth() / PLANE_BITMAP_ELEMENT_BITS;
        if ((DisplayWidth() % PLANE_BITMAP_ELEMENT_BITS) > 0)
        {
            colsNum++;
        }

        uint32_t position = posY * colsNum + col;

        if (colorMask)
            _planeBitmap[position] |= 1 << shift;
        else
            _planeBitmap[position] &= ~(1 << shift);
    }
}


bool Canvas::SetSize(uint16_t width, uint16_t height)
{
    _width = width;
    _height = height;

    int cols = _width / PLANE_BITMAP_ELEMENT_BITS;
    if ((_width % PLANE_BITMAP_ELEMENT_BITS) != 0)
    {
        cols++;
    }

    _planeBitmapSize = cols * _height;

    if ((_planeBitmap = IsSet() ? (uint8_t *)realloc((void *)_planeBitmap, _planeBitmapSize) : (uint8_t *)malloc(_planeBitmapSize)) == NULL)
    {
        Reset();
        return false;
    }

    Clear();

    return true;
}


void Canvas::Clear(void)
{
    memset(_planeBitmap, 0, _planeBitmapSize);
}


uint8_t* Canvas::GetBitmap(void)
{
    return _planeBitmap;
}


bool Canvas::IsSet()
{
    return _planeBitmapSize != NULL;
}
