/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "stats_report.h"
#include "Graphics/RK043FN48H.h"
#include "LCD_DISCO_F746NG/LCD_DISCO_F746NG.h"

RK043FN48H graphics;
LCD_DISCO_F746NG lcd;

DigitalOut led1(LED1);



#define SLEEP_TIME                  200 // (msec)
#define PRINT_AFTER_N_LOOPS         20

// main() runs in its own thread in the OS
int main()
{
    SystemReport sys_state( SLEEP_TIME * PRINT_AFTER_N_LOOPS /* Loop delay time in ms */);

    // display.Clear(LCD_COLOR_RED);

    graphics.SetActiveLayer(Background);
    graphics.SetBackgroundColor(LCD_COLOR_BLACK);
    graphics.SetActiveLayer(Foreground);


    graphics.SetBackColor(LCD_COLOR_BLACK);
    graphics.SetTextColor(LCD_COLOR_LIGHTGRAY);
    graphics.DisplayStringAt(10, 10, (unsigned char*)TITLE, CENTER_MODE);
    graphics.DisplayStringAt(10, 70, (unsigned char*)TITLE, CENTER_MODE);
    graphics.DisplayStringAt(10, 40, (unsigned char*)TITLE, CENTER_MODE);

    int xrand = 0,yrand = 0;
    uint32_t colorshift = LCD_COLOR_WHITE;
    int count = 0;
    while (true) {
        // Blink LED and wait 0.5 seconds
        led1 = !led1;
        wait_ms(SLEEP_TIME);

        // xrand = 10 + std::rand()%470;
        // yrand = 10 + std::rand()%262;

        // colorshift = colorshift << (rand()%5);
        // colorshift = colorshift >> (rand()%3);
        // graphics.SetForegroundColor(colorshift);
        // graphics.FillCircle(xrand,yrand,5);

        if ((0 == count) || (PRINT_AFTER_N_LOOPS == count)) {
            // Following the main thread wait, report on the current system status
            sys_state.report_state();
            count = 0;
        }
        ++count;
    }
}
