/***************************************************
  This is a library for fona sim808

  Written by Nerea Gómez.
  
 ****************************************************/
 
 
#ifndef MBED_fona_sim808_H
#define MBED_fona_sim808_H

#include "mbed.h"
#include <cstdlib>
#include <string>


#define DEBUG
#define SIM808_PWR_ON_TIMEOUT 30.0
#define SIM808_TIMEOUT 3.0

class fona_sim808 {
    
    public:
        fona_sim808(PinName pinA, PinName pinD);
        int SIM808_test(float timeout);          //test if SIM808 is on/1 or off/0
        int SIM808_get_response(float timeout);  //fills the SIM808_buffer with response from module
        int SIM808_get_gps_info(float timeout);  //Parses the GPS frame
        int SIM808_set_gps_on(float timeout);    //Sets GPS on
        
        //SIM808 FUNCTIONS
        int SIM808_test_GPRS_ON(int num_retries); //Test if GPRS module is attached
        int SIM808_reset_PDP(int num_retries);    //Reset the PDP context
        int SIM808_set_mux_off(int num_retries);  //Only one TCP connection posible at time
        int SIM808_set_apn(int num_retries);      //Set the APN to movistar.es
        int SIM808_set_gprs_conn(int num_retries);//Brings up the GPRS connection
        int SIM808_set_IP(int num_retries);       //Get an IP address
        int SIM808_get_IP(int num_retries);       //Reset full connection and get a new IP
        
        //SETTERS
        void set_MQ135_ppm(string MQ135_ppm);
        void set_MQ135_air_quality(string MQ135_air_quality);
        void set_MQ7_CO_value(string MQ7_CO_value);
        void set_sound(string sound);
        void set_CO2_ppm(string CO2_ppm);
        void set_CO2_high_alarm(string CO2_high_alarm);
        void set_CO2_dangerous_alarm(string CO2_dangerous_alarm);
        void set_LDR(string LDR);
        void set_V_min(string V_min);
        void set_V_max(string V_max);
        void set_Voltage(string Voltage);
        void set_T_min(string T_min);
        void set_T_max(string T_max);
        void set_Alarm(string Alarm);
        void set_SOC(string MQ135_ppm);
        void set_tmp(string tmp);
        void set_hum(string hum);
        void set_press(string press);             

     
    private:  
        Serial SIM808;
        Timer  thread_timer; 
        int GNSSTATUS;             //GNS STATUS
        int GNSPWR;                //GNS POWER
        char SIM808_buffer[256];   //
        
        //GPS coordenades
        float longitude; 
        float latitude; 
        int altitude;
        float speed;
        char datetimestamp[20];
        
        //DATA
        string moto_data;
        string coma;
        string MQ135_ppm;
        string MQ135_air_quality;
        string MQ7_CO_value;
        string sound;
        string CO2_ppm;
        string CO2_high_alarm;
        string CO2_dangerous_alarm;
        string LDR;
        string V_min;
        string V_max;
        string Voltage;
        string T_min;
        string T_max;
        string Alarm;
        string SOC;
        string tmp;
        string hum;
        string press;

};
 
#endif