#include "fona_sim808.h"
#include "mbed.h"
#include <cstdlib>
#include <string>


fona_sim808::fona_sim808(PinName tx, PinName rx) : SIM808(tx, rx) {
  Serial pc(USBTX, USBRX); // tx, rx



}

int fona_sim808::SIM808_test(float timeout){
    char dato=' ';
    SIM808.printf("AT\n");
    thread_timer.start();
    thread_timer.reset();
    while ((dato != '\r') and (thread_timer.read() < timeout))
    {
        if (SIM808.readable())
            dato = SIM808.getc();
    }
    thread_timer.stop();
    if (dato == '\r')
        return 1;
    else
        return 0;  
}

int fona_sim808::SIM808_get_response(float timeout){
        int i=0;
    char dato=' ';
    
    thread_timer.start();
    
    thread_timer.reset();
    
    while (thread_timer.read() < timeout) {
        
        if (SIM808.readable())  {
            dato = SIM808.getc();
            SIM808_buffer[i] = dato;
            i++;
        }
        
    }
    
    thread_timer.stop();
    SIM808_buffer[i] = 0;
    #ifdef DEBUG
    pc.printf("%s\n", SIM808_buffer);
    #endif
    
    //pc.printf("caracter 1: %c, caracter 2: %c, caracter 3: %c\n", SIM808_buffer[i-4], SIM808_buffer[i-3], SIM808_buffer[i-1]);
    if ((SIM808_buffer[i-1]=='\r') || (SIM808_buffer[i-1]=='\n')) {     //OK system has sent a response      
        if ((SIM808_buffer[i-4]=='O') && (SIM808_buffer[i-3]=='K')) {   //And response is OK      
            return 1;
        }
        else    {
            return 0;                                                   //Or response is ERROR (or other)
        }
    }
    else    
        return -1;                //No response from module
       
}
int fona_sim808::SIM808_get_gps_info(float timeout){
    int i=0, j;
    GNSSTATUS=-1;
    char temporalnumber[12];
    SIM808.printf("AT+CGNSINF\n");
    if (SIM808_get_response(timeout) == 1)   {   //Response OK so parse response
        while ((SIM808_buffer[i] != ':') and (i < 255))
            i++;
        if ((SIM808_buffer[i+2] == '1') && (SIM808_buffer[i+4] == '1'))     {
            GNSSTATUS = 1;
 
            while (SIM808_buffer[i++]!=',');        //First , (post increment)
            while (SIM808_buffer[i++]!=',');        //second , parses datetime
        
            for (j=0; j<4; j++)
            {
                datetimestamp[j] = SIM808_buffer[i];
                i++;
            }
            datetimestamp[4] = '-';
            for (j=5; j<7; j++)
            {
                datetimestamp[j] = SIM808_buffer[i];
                i++;
            }
            datetimestamp[7] = '-';
            for (j=8; j<10; j++)
            {
                datetimestamp[j] = SIM808_buffer[i];
                i++;
            }
            datetimestamp[10] = 'T';
            for (j=11; j<13; j++)
            {
                datetimestamp[j] = SIM808_buffer[i];
                i++;
            }
            datetimestamp[13] = ':';
            for (j=14; j<16; j++)
            {
                datetimestamp[j] = SIM808_buffer[i];
                i++;
            }
            datetimestamp[16] = ':';
            for (j=17; j<19; j++)
            {
                datetimestamp[j] = SIM808_buffer[i];
                i++;
            }
            datetimestamp[19]=0;
            i+=5;   
                 
            #ifdef DEBUG
            pc.printf("DATETIME: %s\n",datetimestamp);
            #endif
            
            //parse latitude
            j=0;
            while (SIM808_buffer[i]!=',')   {       //fourth ,
                temporalnumber[j++] = SIM808_buffer[i];
                i++;
            }
            i++;
            temporalnumber[j]=0;
            #ifdef DEBUG
            pc.printf("latitude: %s\n",temporalnumber);
            #endif            
            latitude = atof(temporalnumber);
            i++;
            
            //parses longitude
            j=0;
            while (SIM808_buffer[i]!=',')   {       //fifth ,
                temporalnumber[j++] = SIM808_buffer[i];
                i++;
            }
            i++;
            temporalnumber[j]=0;
            #ifdef DEBUG
            pc.printf("longitude: %s\n",temporalnumber);
            #endif                       
            longitude = atof(temporalnumber);
            
            //parses altitude            
            j=0;
            while (SIM808_buffer[i]!=',')   {       //sixth
                temporalnumber[j++] = SIM808_buffer[i];
                i++;
            }
            i++;
            temporalnumber[j]=0;
            #ifdef DEBUG
            pc.printf("altitude: %s\n",temporalnumber);
            #endif                        
            altitude = atoi(temporalnumber);
            
            //parses speed            
            j=0;
            while (SIM808_buffer[i]!=',')   {       //seventh
                temporalnumber[j++] = SIM808_buffer[i];
                i++;
            }
            i++;
            temporalnumber[j]=0;
            #ifdef DEBUG
            pc.printf("speed: %s\n",temporalnumber);
            #endif                       
            speed = atof(temporalnumber);                                    
        }
        else if ((SIM808_buffer[i+2] == '1') && (SIM808_buffer[i+4] == '0'))    {
            GNSSTATUS = 0;
        }
    }
    return GNSSTATUS;         

        
}
int fona_sim808::SIM808_set_gps_on(float timeout){
    int i=0;
    GNSPWR=0;
    SIM808.printf("AT+CGNSPWR?\n");
    if (SIM808_get_response(timeout) == 1)   {   //Response OK
        while ((SIM808_buffer[i] != ':') and (i < 255))
            i++;
        pc.printf("Dato: %c, %d", SIM808_buffer[i+2],i);    
        if (SIM808_buffer[i+2] == '0')   {              //IF GPS is OFF try to connect and test again
            #ifdef DEBUG
            pc.printf("connecting GPS\n");
            #endif
            SIM808.printf("AT+CGNSPWR=1\n");
            if (SIM808_get_respose(timeout) == 1)   {   //Response OK, so GNS power should be now on
                SIM808.printf("AT+CGNSPWR?\n");         // lets try the 2nd time
                if (SIM808_get_respose(timeout) == 1)   {   //Response OK
                    while ((SIM808_buffer[i] != ':') and (i < 255))
                        i++;
                }
            }
        }
        if (SIM808_buffer[i+2] == '1')   {
            GNSPWR=1;
        }
    }
    
}
int fona_sim808::SIM808_test_GPRS_ON(int num_retries) {
    int i=0;
    int attached=0;
    while (i < num_retries) {
        SIM808.printf("AT+CGATT?\n");
        if (SIM808_get_respose(SIM808_TIMEOUT) == 1)   {   //Response OK
            while ((SIM808_buffer[i] != ':') and (i < 255))
                i++;
            if (SIM808_buffer[i+2] == '1')   {      //GPRS ON
                attached = 1;
                i = num_retries;
            }
            else    {
                wait(3);  //in case SIM808 is listenning but detached wait 3"
            }
        }
        i++;
    }
    return attached;
    }
int fona_sim808::SIM808_reset_PDP(int num_retries) {
    int i=0;
    int shut_off=0;
    while (i < num_retries) {
        SIM808.printf("AT+CIPSHUT\n");
        if (SIM808_get_respose(SIM808_TIMEOUT) == 1)   {   //Response OK
            shut_off = 1;
            i = num_retries;
        }
        else    {
            wait(3);  //in case SIM808 fails at hutting off
        }
        i++;
    }
    return shut_off;
    }
int fona_sim808::SIM808_set_mux_off(int num_retries) {
     int i=0;
     int mux_off=0;
    while (i < num_retries) {
        SIM808.printf("AT+CIPMUX=0\n");
        if (SIM808_get_respose(SIM808_TIMEOUT) == 1)   {   //Response OK
            mux_off = 1;
            i = num_retries;
        }
        else    {
            wait(3);  //in case SIM808 fails at setting off the multiplexor
        }
        i++;
    }
    return mux_off;      
    }
int fona_sim808::SIM808_set_apn(int num_retries) {
    int i=0;
    int apn_set=0;
    while (i < num_retries) {
        SIM808.printf("AT+CSTT=\"movistar.es\",\"MOVISTAR\",\"MOVISTAR\"\n");
        if (SIM808_get_respose(SIM808_TIMEOUT) == 1)   {   //Response OK
            apn_set = 1;
            i = num_retries;
        }
        else    {
            wait(3);  //in case SIM808 fails at setting up the APN movistar
        }
        i++;
    }
    return apn_set;       
}
int fona_sim808::SIM808_set_gprs_conn(int num_retries)    {
    int i=0;
    int gprs_set=0;
    while (i < num_retries) {
        SIM808.printf("AT+CIICR\n");
        if (SIM808_get_respose(SIM808_TIMEOUT) == 1)   {   //Response OK
            gprs_set = 1;
            i = num_retries;
        }
        else    {
            wait(3);  //in case SIM808 fails at setting up the APN movistar
        }
        i++;
    }
    return gprs_set;       
}

int fona_sim808::SIM808_set_IP(int num_retries)    {
    int i=0, j, num_points;
    int IP_set=0;
    while (i < num_retries) {
        SIM808.printf("AT+CIFSR\n");
        SIM808_get_respose(SIM808_TIMEOUT) ;
        j=0;
        num_points = 0;
        while ((SIM808_buffer[j] != 0) && (j < 256))    {
            if (SIM808_buffer[j] == '.')
                num_points++;
            j++;
        }
        if (num_points == 3)   {   //Response a valid IP (at less 3 points :)
            IP_set = 1;
            i = num_retries;
        }
        else    {
            wait(3);  //in case SIM808 fails at setting up the APN movistar
        }
        i++;
    }
    return IP_set;       
}
int fona_sim808::SIM808_get_IP(int num_retries){
    int IP_set=0;
    if (SIM808_test_GPRS_ON(num_retries)) {                   //1st test if GPRS ON
        if (SIM808_reset_PDP(num_retries))    {               //2nd reset the PDP context            
            if (SIM808_set_mux_off(num_retries))  {           //3rd turns off the multiplexor
                if (SIM808_set_apn(num_retries))   {          //4th set movistar as APN
                    if (SIM808_set_gprs_conn(num_retries)) {  //5th set GPRS connection
                        if (SIM808_set_IP(num_retries))     { //6th Get a proper IP
                            IP_set = 1;       
                        }
                    }
                }
            }
        }
    }
    return IP_set;
}
//*****************************************************************************
// Send all the data to the server [SYSTEM MUST BE CONNECTED]
//*****************************************************************************
int fona_sim808::SIM808_send_JSON()    {
    int i = 0;
    char str_len[4];                            //taking into account never will be more than 999....

    char lat[11];
    char lon[12];
    char alt[9];
    char spd[7];
    char dat[20];
    
    sprintf (lon, "%f", longitude);
    sprintf (lat, "%f", latitude);
    sprintf (alt, "%d", altitude);
    sprintf (spd, "%f", speed);
    sprintf (dat, "%s", datetimestamp);
    lon[11] = 0;
    lat[10] = 0;
    alt[8] = 0;
    spd[6] = 0;
    dat[19] = 0;
       //JSON

    
    string POSTheader("POST /api/data HTTP/1.1\nHost: postlowcit.azurewebsites.net\nContent-Type: application/json\nContent-Length: ");
    string JSONlon("{\"matricula\":\"8538GCS\",\"GPSlongitud\":\"");
    string JSONlat("\",\"GPSlatitud\":\"");
    string JSONalt("\",\"GPSaltitud\":\"");
    string JSONspd("\",\"GPSspeed\":\"");
    string JSONdat("\",\"GPShora\":\"");
    string JSONsoc("\",\"soc\":\"");
    string JSONvolt("\",\"voltage\":\"");
    string JSONdatos("\",\"datos\":\"")
    string JSONfin("\"}");
    coma= ",";
    
    moto_data=MQ135_ppm + coma + MQ135_air_quality + coma + MQ7_CO_value + coma + sound + coma + CO2_ppm + coma + CO2_high_alarm + coma+CO2_dangerous_alarm + 
    coma + LDR + coma + V_min + coma+ V_max + coma+ Voltage +coma+T_min +coma+ T_max +coma+ Alarm + coma+SOC + coma+tmp +coma+ hum +coma+ press ;
  
    string JSON = JSONlon + lon + JSONlat + lat + JSONalt + alt + JSONspd + spd + JSONdat + dat + JSONsoc + SOC+ JSONvolt + voltage + JSONdatos + moto_data + JSONfin;
    #ifdef DEBUG
        pc.printf("%s\n", JSON); 
    #endif
    i=0;
    while (JSON[i] != 0)
        i++; 
        

    sprintf (str_len, "%d", i);

    str_len[3] = 0;
    i+=111;                    //JSON + POST header + length + 2cr... DO NOT TOUCH (yeahh... grandmas count)
    string HEADER = POSTheader + str_len + "\n\n";  
    #ifdef DEBUG
        pc.printf("aqui2"); 
    #endif
                              
    //SIM808.printf("AT+CIPSTART=\"TCP\",\"130.206.138.15\",\"10002\"\r");      //development mobility
    SIM808.printf("AT+CIPSTART=\"TCP\",\"postlowcit.azurewebsites.net\",\"80\"\r");        //Azure
    if (SIM808_get_respose(SIM808_TIMEOUT) == 1)   {   //Response OK
        #ifdef DEBUG
            pc.printf("AT+CIPSEND=%d\n", i); 
        #endif
        SIM808.printf("AT+CIPSEND=%d\n", i);

        wait(0.5);
        #ifdef DEBUG
        pc.printf("Enviando datos%s%s\n\n\n",HEADER,JSON);
        #endif
        SIM808.printf("%s%s\003003", HEADER,JSON);
        wait(10);
        return 1;
    }
    return 0;
    
}


void fona_sim808::set_MQ135_ppm(string MQ135_ppm){
    this.MQ135_ppm = MQ135_ppm;
    }
void fona_sim808::set_MQ135_air_quality(string MQ135_air_quality){
    
    }
void fona_sim808::set_MQ7_CO_value(string MQ7_CO_value){
    
    }
void fona_sim808::set_sound(string sound){
    
    }
void fona_sim808::set_CO2_ppm(string CO2_ppm){
    }
void fona_sim808::set_CO2_high_alarm(string CO2_high_alarm){
    
    }
void fona_sim808::set_CO2_dangerous_alarm(string CO2_dangerous_alarm){
    
    }
void fona_sim808::set_LDR(string LDR){
    
    }
void fona_sim808::set_V_min(string V_min){
    
    }
void fona_sim808::set_V_max(string V_max){
    
    }
void fona_sim808::set_Voltage(string Voltage){
    
    }
void fona_sim808::set_T_min(string T_min){
    
    }
void fona_sim808::set_T_max(string T_max){
    
    }
void fona_sim808::set_Alarm(string Alarm){
    
    }
void fona_sim808::set_SOC(string MQ135_ppm){
    
    }
void fona_sim808::set_tmp(string tmp){
    
    }
void fona_sim808::set_hum(string hum){
    
    }
void fona_sim808::set_press(string press){
    
    }



