/***************************************************
  This is a library for grove CO2 sensor

  Written by Nerea Gómez.
  
 ****************************************************/

#ifndef MBED_CO2_grove_H
#define MBED_CO2_grove_H

 
#include "mbed.h"

class CO2_grove {
    public:
        CO2_grove(PinName tx, PinName rx);
        void zeroPoint_calibration();
        void calibracion_spanPoint_CO2();
        int getPPM_CO2();
        int correct_checkSum();
        int  high_level_alarm( int CO2PPM );
        int dangerous_level_alarm(int CO2PPM);
        float getTemperature(char data[]);
        
      
    private:  
        Serial _co2;
        int ppm;
        char data[];
        uint8_t cmd_zeroPoint_calibration[];
        uint8_t cmd_get_sensor[];
        
       
};
 
#endif
 