#include "CO2_grove.h"
#include "mbed.h"

CO2_grove::CO2_grove(PinName tx, PinName rx): _co2(tx,rx) {
   _co2.baud(9600);
}

void CO2_grove::zeroPoint_calibration(){
  const uint8_t cmd_zeroPoint_calibration[] = {
        0xff, 0x01, 0x87, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x78
        };
   //Envio de la trama
    for (int i=0; i<9; i++) {
        _co2.putc(cmd_zeroPoint_calibration[i]);
    }
}
    
void CO2_grove::calibracion_spanPoint_CO2(){
     //Trama que hay que enviar para calibrar el punto zero
    const uint8_t cmd_get_sensor[] = {
        0xff, 0x01, 0x87, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x78
    };
    
    //Emvio de la trama
    for (int i=0; i<9; i++) {
        _co2.putc(cmd_get_sensor[i]);
    }
}
int CO2_grove::getPPM_CO2(){
    //Trama que hay que enviar para la peticion de PPM
    const uint8_t cmd_get_sensor[] = {
        0xff, 0x01, 0x86, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x79
    };

    //Emvio de la trama
    for (int i=0; i<9; i++) {
        _co2.putc(cmd_get_sensor[i]);
    }

    char data[9];
    //Almacenamiento de la trama de respuesta en el array
    for(int j=0; j<9; j++) {
        data[j]=_co2.getc();
    }


    return (int) data[2]*256+ (int)data[3];
}

int CO2_grove::correct_checkSum(){
     return 1;
}

int CO2_grove::high_level_alarm(int CO2PPM){
     if(CO2PPM >= 1000 && CO2PPM <1500) {
        return 1;
    } else {
        return 0;
    }
}
int CO2_grove::dangerous_level_alarm(int CO2PPM){
     if(CO2PPM >= 1500) {
        return 1;
    } else {
        return 0;
    }
}
float CO2_grove::getTemperature(char data[]){
    
    int byte4 = (int) data[4];

    return ( (byte4 - 32)*(5/9));
}
     