/***************************************************
  This is a library for BMS

  Written by Nerea Gómez.
  
 ****************************************************/

#ifndef MBED_BMS_H
#define MBED_BMS_H

#include "mbed.h"

class BMS {
    public:
        BMS(PinName rd, PinName td);
        void init_bms();
        void data_request();
        void int2bin(int value, char* buffer, int bufferSize);
        void read_data();
        float get_min_V();
        float get_max_V();
        float get_voltage();
        int get_T_min();
        int get_T_max();
        char get_precharged_value();
        char get_rely_value();
        char get_alarm();
        
      
    private:  
        CAN _bms;
        long frequency;
        CANMessage req_msg;
        CANMessage read_msg;
        /**Voltage attributes**/
        int V_min_l;        //
        int V_min_h;        //Minimum voltage
        float V_min;        //
        int V_max_l;        //
        int V_max_h;        //Maximum voltage
        float V_max;        //
        float voltage;      //Battery voltage
        
        /**Temperature atributes**/
        int T_min;         //Minimum temperature
        int T_max;         //Maximum temperature
        int offset_T;      //Temperature offset
        
        /**Other attributes**/
        int precharged;
        char binaryBuffer[9]; // 8 bits plus null terminator
        char precharged_c;    //Precharged bit
        char rely_c;          //Rely bit
        char alarm_c;         //Alarm bit
        
        
       
};
 
#endif