#include "BMS.h"
#include "mbed.h"

//Constructor
BMS::BMS(PinName rd, PinName td): _bms(rd,td) {
   
   frequency=250000;   //Set frequency param              
}

void BMS::init_bms(){
    _bms.frequency(frequency);
    offset_T=40;
    }
void BMS::data_request(){
    
    req_msg.id=0x200;
    req_msg.data[0] = 0x10;
    req_msg.data[1] = 0x1A;
    req_msg.data[2] = 0x00;
    req_msg.data[3] = 0x02;
    req_msg.data[4] = 0x00;
    req_msg.data[5] = 0x00;
    req_msg.data[6] = 0x00;
    req_msg.data[7] = 0x03;         
         
    _bms.write(req_msg);
}
void BMS::int2bin(int value, char* buffer, int bufferSize) {
  char *nextChar = buffer + bufferSize-2;            // location to write the least significant bit
 
  for (int i = 0; i<(bufferSize-1); i++) {                    // for each bit
    (value & (1<<i)) ? *nextChar  = '1' : *nextChar  = '0'; // if set set to '1' else '0'
    nextChar --;
  }
 
  *(buffer + bufferSize-1) = 0;  // add the null terminator
}
void BMS::read_data(){
     Serial pc(USBTX,USBRX);
     while(_bms.read(read_msg)){
        if (read_msg.id == 1){
               
                 //Tension min
                 pc.printf("Message received: %d\n", read_msg.id);
                 V_min_l = read_msg.data[0];
                 V_min_h = read_msg.data[1];
                 V_min = V_min_l*256 + V_min_h;
                 pc.printf("V min: %f\n\r", V_min);
                 
                 //Tension max
                 V_max_l = read_msg.data[2];
                 V_max_h = read_msg.data[3];
                 V_max = V_max_l*256 + V_max_h;
                 pc.printf("V max: %f\n\r", V_max);
                 
                 //Temperatura min
                 T_min = read_msg.data[4]-offset_T;
                 pc.printf("T min: %d\n\r", T_min);
                 
                 //Temperatura min
                 T_max = read_msg.data[5]-offset_T;
                 // float V_max = V_max_l*256 + V_max_h;
                 pc.printf("T max: %d\n\r", T_max);
           

                 //Precharged cmd
                 precharged = read_msg.data[6];
                 int2bin(precharged, binaryBuffer, 9) ;
                 precharged_c=binaryBuffer[0];
                 pc.printf("Precharged: %d\r\n", precharged);
                 pc.printf("Precharged: %c \r\n ", binaryBuffer[0]);
                 
                 //Rely
                 rely_c=binaryBuffer[1];
                 pc.printf("Rely: %c \r\n", binaryBuffer[1]);
                    
                 //Alarm
                 alarm_c =binaryBuffer[2];
                 pc.printf("Alarm: %c \r\n ", binaryBuffer[2]);
                 
                }
    
    }
    }
float BMS::get_min_V(){
    return V_min;
    }
    
float BMS::get_max_V(){
    return V_max;
    }
float BMS::get_voltage(){
    voltage = (V_min + V_max)/2;
    return voltage;
    }    
int BMS::get_T_min(){
    return T_min;
    }
int BMS::get_T_max(){
    return T_max;
    }
char BMS::get_precharged_value(){
    return precharged_c;
    }
char BMS::get_rely_value(){
    return rely_c;
    }
char BMS::get_alarm(){
    return alarm_c;
    }