/* ===================================================================
Copyright © 2016, AVNET Inc.  

Licensed under the Apache License, Version 2.0 (the "License"); 
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, 
software distributed under the License is distributed on an 
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
either express or implied. See the License for the specific 
language governing permissions and limitations under the License.

======================================================================== */
#include <string>
#ifndef __SENSORS_H_
#define __SENSORS_H_

//********************************************************************************************************************************************
//* Create string with sensor readings that can be sent to flow as an HTTP get
//********************************************************************************************************************************************

void sensors_init(void);
void read_sensors(void);
void ProcessUsbInterface(void);

#define SENSOR_FIELD_LEN_LIMIT  32
typedef struct
{
    float   Temperature;
    float   Humidity;
    float   AccelX;
    float   AccelY;
    float   AccelZ;
    int     MagnetometerX;
    int     MagnetometerY;
    int     MagnetometerZ;
    int     AmbientLightVis;
    int     AmbientLightIr;
    float   UVindex;
    int     Proximity;
    float   Temperature_Si7020;
    float   Humidity_Si7020;
    int16_t   Signal_Strength;
    int16_t   Error;
    string *  Neighbor;
} K64F_Sensors_t ;

extern K64F_Sensors_t  SENSOR_DATA;

extern I2C i2c;    //SDA, SCL -- define the I2C pins being used
extern Serial pc; // tx, rx
#define PRINTF pc.printf
#define PUTS   pc.puts
#define USE_COLOR
#ifdef USE_COLOR
 #define BLK "\033[30m"
 #define RED "\033[31m"
 #define GRN "\033[32m"
 #define YEL "\033[33m"
 #define BLU "\033[34m"
 #define MAG "\033[35m"
 #define CYN "\033[36m"
 #define WHT "\033[37m"
 #define DEF "\033[39m"
#else
 #define BLK
 #define RED
 #define GRN
 #define YEL
 #define BLU
 #define MAG
 #define CYN
 #define WHT
 #define DEF
#endif

#endif