/*
AnalogIn cam1(CAM1_IN);
DigitalOut camSi(CAM_SI);
DigitalOut camClk(CAM_CLK); // Definining camera pins. 
*/
#include "LineScan.h"

uint16_t read1Bit(AnalogIn cam, DigitalOut *camClk){
    uint16_t pixel;
    
    //read pixel n
    pixel = cam.read_u16();
    
    //clock pulse for next pixel n + 1
    *camClk = 1;
    *camClk = 0;
    
    return pixel;  //return result as an uint16_t (16 bit integer)
}

void startRead(DigitalOut *camSi, DigitalOut *camClk){
    //pulse first clock cycle and start integral pin
    *camSi = 1;
    *camClk = 1;
    *camSi = 0;
    *camClk = 0;
}

int processFn(uint16_t *array, int arraySz){
    int lineCtr = 0;
    
    //replace with cross correlation function or averaging function
    //currently returns index of smallest item
    //skip 15 indices on both ends as they are noisy
    for(int i = 16; i < arraySz - 15; i++){
        if(array[i] < array[lineCtr])
            lineCtr = i;
    }
    
    return lineCtr;
}

//call after integration time is done, returns index of array line is expected to be at
int getLinePos(AnalogIn cam, DigitalOut *camSi, DigitalOut *camClk){
    uint16_t lineAry[NUM_PIX];
    int position;
    
    //read 
    startRead(camSi, camClk);
    for(int i = 0; i < NUM_PIX; i++){
        lineAry[i] = read1Bit(cam, camClk);
    }
    
    //process line scan data
    position  = processFn(lineAry, NUM_PIX);
    
    return position;
}

/*
sample call (handler thread):

while(1){
   linePos  = getLinePos(cameraIn1, si, clk);   //volatile linePos, replace with steering angle and read 2 cameras?
   Thread::wait(14);    //sleep for 14 us
}
*/