#include "mbed.h"
#include <math.h>
#include <inttypes.h>
#include "ADXL355.h"
#include "CALIBRATION.h"

Serial pc(USBTX, USBRX);

ADXL355 accl(SPI1_CS0, SPI1_MOSI, SPI1_MISO, SPI1_SCLK);    // PMOD port

CALIBRATION test;

#define pi 3.14159265;

float angle[3][12] = {  {-55, -125, -147, 33, -128, 52, 0, 0, 0, 0, 0, 0},
    {6, -6, 20, -20, -69, 69, 0, 0, 0, 0, 0, 0 },
    {1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0}
};

float meas[3][12] =  {  {-0.09, 0.16,  -0.31,  0.37,  0.91,  -0.88},
    {-0.78, 0.81,  -0.46,  0.49,  -0.28,  0.32},
    {0.54,  -0.55, -0.78,  0.76,  -0.20,  0.20}
};
void adxl_init()
{
    uint8_t res;
    
    //getting Analog Device ID
    res = accl.read_reg(accl.DEVID_AD);
    pc.printf("AD id = %x \r\n",res);
    //getting MEMS ID
    res = accl.read_reg(accl.DEVID_MST);
    pc.printf("MEMS id = %x \r\n",res);
    //getting DEVICE ID
    res = accl.read_reg(accl.PARTID);
    pc.printf("DEVICE id = %x \r\n",res);
    //getting REVISION ID
    res = accl.read_reg(accl.REVID);
    pc.printf("REVISION id = %x \r\n",res);
    
    //setting RANGE
    accl.set_device(accl.RANGE20);
    res = accl.read_reg(accl.RANGE);
    pc.printf("RANGE register value = %x \r\n",res); 
    if(res == 0x01 | res == 0x81 | res == 0xC1 | res == 0x41) {
        //range of +/-10G
        pc.printf("RANGE is +/-10G \r\n",res);
        pc.printf("Sensitivity is %f \r\n",accl.axis357_sens);
    } else if(res == 0x02 | res == 0x82 | res == 0xC2 | res == 0x42) {
        //range of +/-20G
        pc.printf("RANGE is +/-20G \r\n",res);
        pc.printf("Sensitivity is %f \r\n",accl.axis357_sens);
    } else if (res == 0x03 | res == 0x83 | res == 0xC3 | res == 0x43) {
        //range of +/-40G
        pc.printf("RANGE is +/-30G \r\n",res);
        pc.printf("Sensitivity is %f \r\n",accl.axis357_sens);
    } else {
        pc.printf("Unable to read RANGE Register\r\n");

    }
  
    //setting FILTER
    //accl.set_filter_ctl_reg(accl.HPFOFF , accl.ODR3HZ);
    //setting MODE 
    accl.set_power_ctl_reg(accl.MEASUREMENT);
    
    //reading PWR CTL Register
    res = accl.read_reg(accl.POWER_CTL);
    pc.printf("power control on measurement mode = %x \r\n",res);
}

void adxl_stream_results()
{
    float x, y, z;
    float t;
    uint32_t raw_x, raw_y, raw_z, raw_t;
    // save data info a file
     pc.printf("GET device data [x, y, z, t] \r\n");
    pc.printf("x \t raw x \t y \t raw \t y \t z \t raw z \t t \t raw t \r\n");
    for(int i=0; i<20; i++) {
        raw_x = accl.scanx();
        raw_y = accl.scany();
        raw_z = accl.scanz();
        x = accl.convert(raw_x)*accl.axis357_sens;
        y = accl.convert(raw_y)*accl.axis357_sens;
        z = accl.convert(raw_z)*accl.axis357_sens;
        t = 25+float(accl.scant()-1852)/(-9.05);
        pc.printf("%f \t %d \t %f \t %d \t %f \t %d \t %f \t %d \r\n" , x, raw_x, y, raw_y, z, raw_z, t, raw_t);
        wait(0.1);
    }
}


int main()
{
    pc.baud(9600);
    pc.printf("SPI ADXL355 and ADXL357 Demo\r\n");
    pc.printf("04/09/2018 V1.0\r\n");
    
    accl.reset();
    
    adxl_init();
    
    adxl_stream_results();

    while(1) {
        pc.printf("Do you want to repeat the measurement (y/n)?\r\n");
        char calib = pc.getc();
        switch(calib) {
            case 'y': {
                adxl_stream_results();
                break;
            }
            case 'n': {
                pc.printf("Thank you for evaluating the ADXL355/357\r\n");
                pc.printf("You may now close the serial terminal\r\n");
                break;
            }
            default:
                pc.printf("Input value not recognized, try again! \r\n");
                break;
        }
    }
}
