#include "mbed.h"
#include "nexpaq_mdk.h"
#include "MAX44000.h"

MAX44000 max44000(P1_6, P1_7);
PwmOut ledR(P2_4);
PwmOut ledG(P2_5);
PwmOut ledB(P2_6);
DigitalIn button(P0_1, PullUp);

/***** Definitions *****/
#define		FUNCTION_TABLE_NUM					1
#define		UUID_NUM							16			//UUID number is 16, don't change it
#define     LOOP_DELAY                          100
#define     PROX_THRESHOLD                      10

/***** Globals *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len);
const MDK_REGISTER_CMD my_cmd_func_table[FUNCTION_TABLE_NUM] = {
    {0x2700, my_function_CMD_2700},		// Command -> function
};

int lastPrx = 0;
unsigned char prxPress = 0x02;
int lastBtn = 1;
unsigned char btnPress = 0x01;

/***** Functions *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
    ledR = 1.0f - (pData[0] / 255.0f);
    ledG = 1.0f - (pData[1] / 255.0f);
    ledB = 1.0f - (pData[2] / 255.0f);
    np_api_upload(0x2701, &response, 1);
}

/******************************************************************************/
void app_setup()
{
    if ( np_api_register((MDK_REGISTER_CMD*)my_cmd_func_table, FUNCTION_TABLE_NUM) == MDK_REGISTER_FAILD ) {
        // Register failed handle code
        error("MDK Register Failed");
    }
    max44000.init(MAX44000::MODE_ALS_PROX, MAX44000::ALSTIM_64X, MAX44000::ALSPGA_1X, MAX44000::DRV_10);
    ledR = 1.0f;
    ledG = 1.0f;
    ledB = 1.0f;
}

void app_loop()
{
    int proxData = max44000.readReg(MAX44000::REG_PRX_DATA);
    if (proxData > PROX_THRESHOLD) {
        if (!lastPrx) {
            np_api_upload(0x2800, &prxPress, 1);
        }
        lastPrx = 1;
    } else {
        lastPrx = 0;
    }

    if (!button && lastBtn) {
        np_api_upload(0x2800, &btnPress, 1);
    }
    lastBtn = button;
}

int main(void)
{

    np_api_init();
    app_setup();
    np_api_start();

    while(1) {
        Thread::wait(LOOP_DELAY);
        app_loop();
        np_api_bsl_chk();
    }

    return 0;
}

