/*
*
* 1.8 - 3.6V (Vdd)
* 1.62 - 3.6 (Vddio)
*
*
*Altitude = 44330*(1-(p/p0)^(1/5.255))
*   set p0 to sealevel pressure
* delta p = 1hPa = 8.43m at sea level
*
*/

/*
*Pinout:
*pin9  = SDA
*pin10 = SCL
*pin11 = XCLR (digital out; active low; Resets sensor)
*pin12 = EOC ("end of conversation"; signal when conversion finished)
*
*/

#include "mbed.h"
#include "BMP085.h"

I2C i2c(p9, p10); // sda, scl
BMP085 alt_sensor(i2c);
Serial pc(USBTX, USBRX); // tx, rx

/*
const int bmp085_address = 0xEE; //address of bmp085
const int P0 = 101325; //pressure at sea level

void bmp085_calibration(void);
void display_calibration(void);
unsigned short read_short(int,int);

void write_char(int,int,int);

long get_raw_temp(void);
void calculations(long);

float get_temperature(void);
long get_pressure(void);
float get_altitude(long);
*/

//short AC1, AC2, AC3, B1, B2, MB, MC, MD, OSS;
//unsigned short  AC4, AC5, AC6;

int main()
{
    pc.baud(9600);
    //alt_sensor.display_cal_param(&pc);
    while(1)
    {
        pc.printf("Temperature: %d\r\n", alt_sensor.get_temperature());
        pc.printf("Pressure: %d\r\n", alt_sensor.get_pressure());
        pc.printf("Altitude: %f\r\n", alt_sensor.get_altitude_ft());
        
        wait(0.5);
    }
    //Initialize
    //OSS = STANDARD; //change between enums under bmp085_oss for desired Sampling resolution

    //calibrate
    //bmp085_calibration();
    //display_calibration();

    //long raw_temp = get_raw_temp();

    //calculations(raw_temp);

    //float altitude = get_altitude(pressure);

    //pc.printf("Temperature: %f\n",temperature);
    //pc.printf("Pressure: %l\n", pressure);
    //pc.printf("Altitude: %f\n", altitude);
}
/*
long get_raw_temp(void)
{
    long raw_temp;

    //Read raw temperature value
    write_char(bmp085_address, 0xF4, 0x2E);
    wait_ms(4.5);
    raw_temp = read_short(bmp085_address, 0xF6);

    return raw_temp;
}

void calculations(long raw_temp)
{
    long X1, X2, B5; //temperature;

    //Start temperature calculation
    X1 = (((long)raw_temp - (long)AC6) * (long)AC5) >> 15;
    X2 = ((long)MC << 11) / (X1 + MD);
    B5 = X1 + X2;
    temperature = ((B5 + 8) >> 4);

    temperature = ((float)temperature / 10.0);

    pc.printf("Temperature: %f\n",temperature);


    long raw_pressure, B6, B3, X3;
    unsigned long B4, B7;

    //Read raw pressure value
    write_char(bmp085_address, 0xf4, 0x34 | (OSS << 6));
    wait_ms(5);
    raw_pressure = read_short(bmp085_address, 0xF6) >> (8 - OSS);

    //Start Pressure calculation
    B6 = B5 - 4000;
    X1 = (B2 * (B6 * B6) >> 12) >> 11;
    X2 = (AC2 * B6) >> 11;
    X3 = X1 + X2;
    B3 = (((AC1 * 4 + X3) << OSS + 2) / 4);
    X1 = (AC3 * B6) >> 13;
    X2 = (B1 * ((B6 * B6) >> 12)) >> 16;
    X3 = ((X1 + X2) + 2) >> 2;
    B4 = (AC4 * (unsigned long)(X3 + 32768)) >> 15;
    B7 = ((unsigned long)(raw_pressure - B3) * (50000 >> OSS));
    if (B7 < 0x80000000)
        pressure = (B7 *2) / B4;
    else
        pressure = (B7 / B4) * 2;

    X1 = (pressure >> 8) * (pressure >>8);
    X1 = (X1 * 3038) >>16;
    X2 = (-7357 * pressure) >>16;
    pressure += (X1 + X2 + 3791)>>4;

    pc.printf("Pressure: %f\n", pressure);

}

float get_temperature(void)
{
    return temperature;
}

long get_pressure(void)
{
    return pressure;
}

float get_altitude(long pressure)
{
    float altitude;

    altitude = (float)44330 * (1 - pow(( pressure/P0), 0.190295));

    pc.printf("Altitude: %f\n", altitude);
    return altitude;

}

void bmp085_calibration(void)
{
    AC1 = read_short(bmp085_address, 0xAA);
    AC2 = read_short(bmp085_address, 0xAC);
    AC3 = read_short(bmp085_address, 0xAE);
    AC4 = read_short(bmp085_address, 0xB0);
    AC5 = read_short(bmp085_address, 0xB2);
    AC6 = read_short(bmp085_address, 0xB4);
    B1  = read_short(bmp085_address, 0xB6);
    B2  = read_short(bmp085_address, 0xB8);
    MB  = read_short(bmp085_address, 0xBA);
    MC  = read_short(bmp085_address, 0xBC);
    MD  = read_short(bmp085_address, 0xBE);

}

void display_calibration(void)
{
    pc.printf("Calibration Values:\n");
    pc.printf("AC1 = %d\n",AC1);
    pc.printf("AC2 = %d\n",AC2);
    pc.printf("AC3 = %d\n",AC3);
    pc.printf("AC4 = %d\n",AC4);
    pc.printf("AC5 = %d\n",AC5);
    pc.printf("AC6 = %d\n",AC6);
    pc.printf("B1 = %d\n",B1);
    pc.printf("B2 = %d\n",B2);
    pc.printf("MB = %d\n",MB);
    pc.printf("MC = %d\n",MC);
    pc.printf("MD = %d\n",MD);
}*/

