/* 
 * In this project LED1 on the mbed board is switched on/off using a web browser.
 * However, you can easily modify the project to remotely switch on/off any external device.
 * The HTTP server is built from an mbed board and an ENC28J60 board.
 * ENC28J60 is driven by the UIPEthernet library <https://github.com/ntruchsess/arduino_uip>.
 * The example is based on the Tuxgraphics Web Switch <http://www.tuxgraphics.org/>.
 */
 
 //data transmission from telnet to UART is very smooth but from uart to telnet is not good when I pasted a text of one page all i got was 
 //garbage.
 
#define TARGET_STM32F103C8T6  1     // uncomment this line when using STM32F103C8T6 boards!                                    

#if defined(TARGET_STM32F103C8T6)
    #define LED_PIN PC_13
    const int OFF = 1;
    const int ON  = 0;
#else
    #define LED_PIN LED1
    const int OFF = 0;
    const int ON  = 1;
#endif

#include "mbed.h"
#include "UIPEthernet.h"
#include "UIPServer.h"
#include "UIPClient.h"
#include "string"


using namespace     std;

Serial pc(PA_9, PA_10); // tx, rx


/////////OLED STUFF//////////////////////////////
#include "Adafruit_SSD1306.h"
//I2C obj(sda,scl);
I2C i2c2(PB_11,PB_10); //read more info about SSD1306 trouble in "SSD1306_test" project. and I don't know why but using PB_8 and PB_9 for I2C screws up SPI or atleast the ENC28J60, need to find out maybe from STM32F103 DATASHEET.
//Adafruit_SSD1306_I2c(I2C &i2c, PinName RST, uint8_t i2cAddress = SSD_I2C_ADDRESS, uint8_t rawHeight = 32, uint8_t rawWidth = 128)
Adafruit_SSD1306_I2c lcd(i2c2,PB_13,0x78,64,128); //also mbed takes i2c address in 8bit mode, any unused pin can be given as "reset" pin.

/////////////////////////////////////////////////////


#define DHCP    1   // if you'd like to use static IP address comment out this line 

// UIPEthernet is the name of a global instance of UIPEthernetClass.
// Do not change the name! It is used within the UIPEthernet library.
UIPEthernetClass    UIPEthernet(PB_5, PB_4, PB_3, PB_6);            // mosi, miso, sck, cs

// However, make sure that it does not collide with any of the SPI pins
// already used in the UIPEthernet(...) constructor above!
// In this example we are turning on/off LED1.
DigitalOut          sw(LED_PIN);            // Change LED_PIN to a pin of your choice.


// If your board/plaform is not present yet then uncomment
// the following two lines and replace TARGET_YOUR_BOARD as appropriate.

//#elif defined(TARGET_YOUR_BOARD)
//UIPEthernetClass    UIPEthernet(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS);   // mosi, miso, sck, cs

//#endif

// Note:
// If it happends that any of the SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS pins collide with LED1 pin
// then either use different SPI port (if available on the board) and change the pin names
// in the constructor UIPEthernet(...) accordingly or instead of using LED1 pin, select
// a free pin (not used by SPI port) and connect to it an external LED which is connected
// to a 220 Ohm resitor that is connected to the groud.
// In the second case remember to replace LED1 in sw(LED1) constructor (see below).
// MAC number must be unique within the connected network. Modify as appropriate.
const uint8_t       MY_MAC[6] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x06 };
const uint16_t      MY_PORT = 23;           // for TELNET connection
EthernetServer      server = EthernetServer(MY_PORT);
#define MAX_NUM_CLIENT 1
EthernetClient clients[MAX_NUM_CLIENT];

void loop();

typedef uint8_t byte;

int main(void) {
    
    pc.baud(57600);
   // pc.format(8,SerialBase::Even,1); 
    pc.printf("Program begins\r\n");
    //lcd.printf("%ux%u OLED Display\r\n", lcd.width(), lcd.height());
    lcd.printf("Telnet Server\n");
    lcd.printf("Waiting for DHCP..\n");
    lcd.display();

#if defined(DHCP)
    pc.printf("Searching for DHCP server..\r\n");
    if(UIPEthernet.begin(MY_MAC) != 1) {
        pc.printf("No DHCP server found.\r\n");
        pc.printf("Exiting application.\r\n");
        return 0;
    }
    pc.printf("DHCP server found.\r\n");
#else
    // IP address must be unique and compatible with your network.
    const IPAddress MY_IP(192, 168, 1, 181);    //  Change as appropriate.
    UIPEthernet.begin(MY_MAC, MY_IP);
#endif
    IPAddress   localIP = UIPEthernet.localIP();
    pc.printf("DHCP assigned IP : ");
    //lcd.clearDisplay();
    //lcd.setTextCursor(0,0);
    lcd.setTextSize(2);
    lcd.printf("IP:");
    for(uint8_t i = 0; i < 4; i++){
        pc.printf("%d.", localIP[i]);
        lcd.printf("%d.", localIP[i]);
        }
    lcd.display();
    pc.printf("Starting Telnet server");
    server.begin();
    while(1) 
    {
        loop();
    }
    
}

          
void clientPrint(char*, EthernetClient*);

void loop() {
  // wait for a new client:
  EthernetClient client = server.available();

  if (client) {

    bool newClient = true;
    for (byte i=0;i<MAX_NUM_CLIENT;i++) {
      //check whether this client refers to the same socket as one of the existing instances:
      if (clients[i]==client) {
        newClient = false;
        break;
      }
    }

    if (newClient) {
      //check which of the existing clients can be overridden:
      for (byte i=0;i<MAX_NUM_CLIENT;i++) {
        if (!clients[i] && clients[i]!=client) {
          clients[i] = client;
          // clead out the input buffer:
          client.flush();
          // clead out the input buffer:
          client.flush();
          pc.printf("We have a new client\r\n");
          clientPrint("Hello Client\r\n",&client);
          clientPrint("my IP ",&client);
          //char localIP[]= UIPEthernet.localIP();
          //client.write(localIP,strlen(localIP));
          break;
        }
      }
    }

    if (client.available() > 0) {
      // read the bytes incoming from the client:
      char thisChar = client.read();
      // echo the bytes back to all other connected clients:
      for (byte i=0;i<MAX_NUM_CLIENT;i++) {
        if (clients[i] && clients[i]!=client) {
          clients[i].write(thisChar);
        }
      }
      // echo the bytes to the server as well:
      pc.putc(thisChar);
    }
  }
  for (byte i=0;i<MAX_NUM_CLIENT;i++) {
    if (!(clients[i].connected())) {
      // client.stop() invalidates the internal socket-descriptor, so next use of == will allways return false;
      clients[i].stop();
    }
  }
  
  
  //This part is what I copied from ESP8266 WIFI TELNET example.
  //check UART for data
  if(pc.readable()){
    /*
    size_t len = Serial.available();
    uint8_t sbuf[len];
    Serial.readBytes((char*)sbuf, len);
    */
    char data_from_uart = pc.getc();
    //push UART data to all connected telnet clients
    for(uint8_t i = 0; i < MAX_NUM_CLIENT; i++){
      if (clients[i] && clients[i].connected()){
        clients[i].write(data_from_uart);
        //wait(0.001);
      }
    }
  }
  
}

void clientPrint(char * str, EthernetClient* client)
{//TODO: make a member for client printf deriving from printf class
    uint8_t i=0;
    while(str[i]!='\0')
    {
        client->write((uint8_t)str[i]);
        i++;
    }
}