#ifndef MYCONFIG_H
#define MYCONFIG_H
#include "ConfigFile.h"
#include <string.h>

class myConfig: public ConfigFile {
public:
    static const int MAXLEN_VALUE = 128;//redeclared because inaccessible
    int getInt(char *key, int dflt=0) {
        char value[MAXLEN_VALUE];
        if (getValue(key, value, sizeof(value))) {
            int val=dflt;
            sscanf(value,"%d", &val);
            return val;
        }
        return dflt;
    }
    int getLookup(char *key, char*names[], int n) {
        char value[MAXLEN_VALUE];
        if (getValue(key, value, sizeof(value))) {
            for (int i = 0; i < n; i++)
                if (strcmp(value, names[i])==0)
                    return i;
        }
        return n;
    }
};

#endif