#ifndef MSGSERIAL_H
#define MSGSERIAL_H
#include "mbed.h"
#define SZ  7
class msgSerial: public Serial {
public:
private:
    void (*onMsgReceived)(char*);
    char in[SZ], out[SZ];
    int ii, io;
    void readByte() {
        if (ii<SZ) {
            in[ii++] = getc();
            if (in[0] != 0x90) {//not a valid message
                ii = 0;
                return;
            }
            if (ii==SZ) {
                if (onMsgReceived)
                    onMsgReceived(in);
                ii = 0;
            }
        }
    }
    void writeByte() {
        if (io<SZ)
            putc(out[io++]);
    }
public:
    msgSerial(PinName out, PinName in, void (*cb)(char*)): Serial(out, in) {
        onMsgReceived = cb;
        attach(this, &msgSerial::readByte, RxIrq);
        attach(this, &msgSerial::writeByte, TxIrq);
        ii = io = 0;
    }
    virtual ~msgSerial(){
        onMsgReceived = 0;
        attach(0, RxIrq);
        attach(0, TxIrq);
        }
    void write(char *m) {
        memcpy(out, m, SZ);
        io = 0;
        writeByte();
    }
};
#endif