#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "ft.h"
#include "ftserver.h"
#define MBED
#include "ftlib.h"


ftServer::ftServer(IpAddr host, unsigned short port) {
    err = listeningSock.bind(Host(host, port));
    if (err) {
        printf("Binding failed!\n");
        errorMsg();
        return;
    }
    printf("Bound to host\n");
    printf("listening on port %d\n", port);
    listeningSock.setOnEvent(this, &ftServer::onTCPEvent);
    index = 0;
    isMsg = false;
    text = 0;
}

void ftServer::errorMsg() {
    switch (err) {
        case __TCPSOCKET_MIN:
            printf("Err: MIN");
            break;
        case   TCPSOCKET_SETUP:
            printf("Err:TCPSocket not properly configured");
            break;
        case   TCPSOCKET_TIMEOUT:
            printf("Err:Connection timed out");
            break;
        case   TCPSOCKET_IF:
            printf("Err:Interface has problems, does not exist or is not initialized");
            break;
        case   TCPSOCKET_MEM:
            printf("Err:Not enough mem");
            break;
        case   TCPSOCKET_INUSE:
            printf("Err:Interface / Port is in use");
            break;
        case   TCPSOCKET_EMPTY:
            printf("Err:Connections queue is empty");
            break;
        case   TCPSOCKET_RST:
            printf("Err:Connection was reset by remote host");
            break;
        case   TCPSOCKET_OK:
            printf("Err:Success");
            break;
        default:
            printf("Err:Unknown");
    }
    printf("\r\n");
}

void ftServer::onTCPEvent(TCPSocketEvent ev) {
    Host client;
    TCPSocket *pConnectedSock;
    switch (ev) {
        case TCPSOCKET_ACCEPT:
            printf("Accept event\r\n");
            err = listeningSock.accept(&client, &pConnectedSock);
            if (err) {
                printf("accept failed!\r\n");
                errorMsg();
                return; //Could not accept client
            }
            printf("Accepted\r\n");
            queue.push_back(new connection(this, client, pConnectedSock));
            break;
        default:
            printf("listenSocket other event\r\n");
            break;
    }
}

void ftServer::remove(connection *c) {
    queue.remove(c);
    delete c;
    int n = 0;
    char s[40];
    for (list<connection*>::iterator i = queue.begin(); i != queue.end(); i++) {
        sprintf(s, "You are in position %d in the queue", n++);
        (*i)->writeStream(s);
    }
}

bool ftServer::startServer() {
    err = listeningSock.listen(); //Starts listening
    if (err) {
        printf("listen failed!\n");
        errorMsg();
        return false;
    }
    printf("listen OK\t");
    return true;
}
/*
void ftServer::pollServer() {
    Net::poll();
}
*/
char* ftServer::render() {
    static char text[40];
    sprintf(text, "%02X %02X %02X %02X %02X %02X %02X; ", msg[0],msg[1],msg[2],msg[3],msg[4],msg[5],msg[6]);
    return text;
}

#if 1
bool ftServer::readStream(TCPSocket *pConnectedSock) {
    char c;
    if (pConnectedSock != queue.front()->socket()) {
        char flush[7];
        pConnectedSock->recv(flush, sizeof(flush));
        return false;
    }
    while (!isMsg) {
        if (pConnectedSock->recv(&c, 1) == 0) {
            printf("NoData ");
            return false; //no data available
        }
        isMsg = c == 0x90;//start of message
        if (isMsg) {//potentially we are at the start of a message
            msg[0] = c; //0x90
            printf(" SOM ");
            index = 1;
            if (text) {
                printf(text);
                delete[] text;
                text = 0;
            }
            break;
        }
        //text
        if (text == 0) {
            textlen = c;//potential length of the string
            text = new char[textlen+1];
            index = 0;
            printf("STX ");
        } else {
            text[index++] = c;
            printf("+");
        }
        if (index == textlen) { //assume the entire string was read
            text[index] = '\0';
            printf(text);
            printf(" ETX ");
//                        if (s == "QUIT")
//                            return false;//in-band signalling, not used
            delete[] text;
            text = 0;
            return false;//text messages are ignored
        }
    }
    index += pConnectedSock->recv(msg+index, sizeof(msg) - index);
    if (index >= sizeof(msg)) {
        printf(render());
        isMsg = false; //start over on the presumption of text
        printf(" EOM\r\n");
        return true; //message is ready
    }
    printf("-");
    return false;
}
#else
bool ftServer::readStream() {
    char c;
    while (pConnectedSock->recv(&c, 1) == 1) {
        char txt[20];
        sprintf(txt, "%02X ", c);
        printf(txt);
    }
    printf(";");
    return false;
}
#endif

bool ftServer::writeStream(char *s) {
    for (list<connection*>::iterator i = queue.begin(); i != queue.end(); i++)
        (*i)->writeStream(s);
    return true;
}

bool ftServer::writeStream(SMESSAGE *m) {
    for (list<connection*>::iterator i = queue.begin(); i != queue.end(); i++)
        (*i)->writeStream(m);
    return true;
}

void connection::onConnectedTCPSocketEvent(TCPSocketEvent ev) {//called as part of NetPoll
    switch (ev) {
        case TCPSOCKET_CONNECTED:
            printf("connectedSocket: Connected to host\n\r");//did not happen
            return;
         case   TCPSOCKET_ACCEPT://should not happen
            printf("connectedSocket: Client is connected, must call accept() to get a new Socket\n\r");
            return;
        case   TCPSOCKET_READABLE: //this happens when data is received
            //printf("connectedSocket: Data in buf\n\r");
            if (server->readStream(pConnectedSock)) {
                //writeStream("received the message");
                //writeStream((SMESSAGE*)(msg+1));
                server->handleMessage();
            }
            return;
        case   TCPSOCKET_WRITEABLE://this happens
            //printf("connectedSocket: Can write data to buf\n\r");
            return;
        case   TCPSOCKET_CONTIMEOUT:
            printf("connectedSocket: Connection timed out\n\r");
            break;
        case   TCPSOCKET_CONRST:
            printf("connectedSocket: Connection was reset by remote host\n\r");
            break;
        case   TCPSOCKET_CONABRT:
            printf("connectedSocket: Connection was aborted\n\r");
            break;
        case   TCPSOCKET_ERROR:
            printf("connectedSocket: Unknown error\n\r");
            break;
        case   TCPSOCKET_DISCONNECTED://this happens
            printf("connectedSocket: Disconnected\n\r");
            break;
        default:
            printf("connectedSocket: Unknown event\r\n");
            return;
    }
    //disconnected socket
    server->remove(this);
}

bool connection::writeStream(char *s) {//I'm not sure this works for large or rapid messages because NetPoll is not called, when I call it it may be recursively
    if (!pConnectedSock)
        return false;
    char l = strlen(s);
    while (pConnectedSock->send(&l, 1)==0);
    while (strlen(s))
        s += pConnectedSock->send(s, strlen(s));
    return true;
}

bool connection::writeStream(SMESSAGE *m) {//I'm not sure this works for large or rapid messages because NetPoll is not called, when I call it it may be recursively
    if (!pConnectedSock)
        return false;
    char header = 0x90;
    char l = 6;
    char i = 0;
    while (pConnectedSock->send(&header, 1)==0);
    while (i<l)
        i += pConnectedSock->send((char*)m+i, l-i);
    return true;
}
