#ifndef FTSERVER_H
#define FTSERVER_H
#include <list>
using namespace std;

void handleMessage(char[7]);
class connection;

class ftServer {
    list<connection*> queue;
    TCPSocket listeningSock;
    TCPSocketErr err;
    char msg[7];
    char *text;
    char textlen, index;
    bool isMsg;
protected:
    void onTCPEvent(TCPSocketEvent ev);
    char* render();
public:
    ftServer(IpAddr host, unsigned short port);
    bool startServer();
//    void pollServer();
    void errorMsg();
    bool readStream(TCPSocket *pConnectedSock);
    bool writeStream(char *);
    bool writeStream(SMESSAGE*);
    void remove(connection* c);
    void handleMessage() {
        ::handleMessage(msg);    //change this to a function pointer
    }
    int clients() { return queue.size();}
};

class connection {
    TCPSocket * pConnectedSock;
    Host client;
    ftServer *server;
    void onConnectedTCPSocketEvent(TCPSocketEvent ev);
public:
    connection(ftServer *svr, Host h, TCPSocket *s): server(svr), client(h), pConnectedSock(s) {
        pConnectedSock->setOnEvent(this, &connection::onConnectedTCPSocketEvent); //Setup the new socket events
        char str[80];
        sprintf(str, "Message from Server: Connection OK. Client nr %d", server->clients());
        writeStream(str);
        //should also send the present state of the inputs, ne clean way to access the ft-interface
    }
    ~connection() {
        pConnectedSock->close();//close and destroy the socket created by 'accept'
    }
    bool writeStream(char *);
    bool writeStream(SMESSAGE*);
    const TCPSocket* socket() const {
        return pConnectedSock;
    }
};

#endif