#ifndef SDP_DATA_H
#define SDP_DATA_H

#include <vector>

extern const unsigned char base_uuid[16];// = { 0xfb, 0x34, 0x9b, 0x5f, 0x80, 0, 0x07, 0x70, 0, 0x10, 0, 0};

class sdp_data {
public:
    enum elements { NULL_, UNSIGNED, SIGNED, UUID, STRING, BOOL, SEQUENCE, ALTERNATIVE, URL};
private:
    enum elements type;
    char size;
    union {
        unsigned data;
        char *str;
#ifdef LONGUUID
        unsigned short uuid[8];
#endif
    };
    vector<sdp_data*> sequence; //not allowed to be in union
    static char ret[12];
    char *longstr;
public:
    sdp_data(): type(NULL_), size(0), longstr(0) {
        //printf("NULL%d ", size);
    }
    sdp_data(unsigned d, unsigned sz=4): type(UNSIGNED), size(sz), longstr(0) {
        data=d;
        //printf("UINT%d=%u ", size, data);
    }
    sdp_data(unsigned short d, unsigned sz=2): type(UNSIGNED), size(sz), longstr(0) {
        data=d;
        //printf("UINT%d=%u ", size, data);
    }
    sdp_data(signed d, unsigned sz=4): type(SIGNED), size(sz), longstr(0) {
        data=d;
           //printf("INT%d=%d ", size, data);
    }
    sdp_data(bool d, unsigned sz=1): type(BOOL), size(sz), longstr(0) {
        data=d;
           //printf("BOOL%d=%u ", size, data);
    }
    sdp_data(char*s, unsigned sz=0): type(STRING), longstr(0) {
        if (sz) size = sz+1;
        else size = strlen(s)+1;
        str = new char[size];
        strncpy(str, s, size);
        str[size-1] = '\0';
           //printf("STR%d='%s' ", size, str);
    }
    sdp_data(enum elements t, unsigned d, unsigned sz=2): type(t), size(sz), longstr(0) {
        if (t==UUID) {
#ifdef LONGUUID
            memcpy(uuid, base_uuid, 16);
            uuid[6] = d;
            uuid[7] = d>>16;
            //       printf("UUID%d=%04X%04X ", size, uuid[7], uuid[6]);
#else
            data = d;
#endif
        } else printf("Please use other constructor for type %d\n", t);
    }
    sdp_data(enum elements t, char *d=0, unsigned sz=0): type(t), size(sz), longstr(0) {
        switch (t) {
#ifdef LONGUUID
            case UUID:
                memcpy(uuid, d, size);
                //           printf("UUID%d=%08X ", size, uuid[6]);
                break;
#endif
            case URL:
                //size = strlen(d)+1;
                str = new char[size+1];
                strcpy(str, d);
                //         printf("URL%d='%u' ", size, str);
                break;
            case SEQUENCE:
            case ALTERNATIVE:
                break;
            default:
                printf("Please use other constructor for type %d\n", t);
        }
    }
    ~sdp_data() {
        switch (type) {
            case STRING:
            case URL:
                delete[] str;
                break;
            case SEQUENCE:
            case ALTERNATIVE:
                for (int i = 0; i < sequence.size(); i++)
                    delete sequence.at(i);
                break;
        }
        if (longstr)
           delete[] longstr;
    }
    void add_element(sdp_data *el) {
        sequence.push_back(el);
        size += el->Size();
    }
    unsigned asUnsigned() ;
    const char* asString(bool alt=false) ;
    unsigned Size() ;
    unsigned items() { return sequence.size();}
    sdp_data* item(int i) { return sequence[i];}
    void remove(int i) { sequence[i] = 0;}
    unsigned sizedesc(unsigned char *buf) ;
    void revcpy(unsigned char*d, const unsigned char*s, int n) ;
    unsigned build(unsigned char *buf, unsigned max) ;
    bool findUUID(unsigned uuid);
};

#endif