#include "Utils.h"
#include "neighbourhood.h"

neighbourhood *neighbors = 0;

int neighbourhood::get(BD_ADDR *a, unsigned char *key) {
    for (list<item>::iterator i = keys.begin(); i != keys.end(); i++)
        if (memcmp(a, &(*i).a, sizeof(BD_ADDR)) == 0) {
            memcpy(key, (*i).lk, lksize);
#ifdef STRICT_MRU
            if (i != keys.begin()) {
                keys.push_front(*i);
                keys.erase(i);
                dirty = true;
            }
#endif
            return 1;
        }
    return 0;
}

int neighbourhood::add(BD_ADDR *a, const unsigned char *key, bool init) {
    for (list<item>::iterator i = keys.begin(); i != keys.end(); i++)
        if (memcmp(a, &(*i).a, sizeof(BD_ADDR)) == 0) {
            memcpy((*i).lk, key, lksize); //assume key has changed, update key
            (*i).used = true;
            return 1;
        }
    //new key
    printf("Neighbourhood: "); printf(a); printf("\n");
    if (keys.size() < cap) {
        keys.push_back(item(a, key, !init));//append as long as there is space
    } else {
        keys.push_front(item(a, key, true));//otherwise prepend
        dirty = true;
    }
    return 0;
}

void neighbourhood::write() {
    int n = 0;
    static const int maxkey = 11;
    unsigned char param[maxkey*(lksize+sizeof(BD_ADDR))+1];
    int k = keys.size()-cap;
    list<item>::iterator i = keys.begin();
    while (i != keys.end()) {
        if (k>0) {
            if (!(*i).used) {
                delete_link_key(&(*i).a);//try to make some room
                keys.erase(i);
                k--;
            } else
                i++;
        } else
            break;
    }
    //hci->delete_link_keys();
    unsigned char *p = &param[1];
    for (list<item>::iterator i = keys.begin(); i != keys.end() && n<maxkey; i++, n++) {
        memcpy(p, &(*i).a, sizeof(BD_ADDR));
        p += sizeof(BD_ADDR);
        memcpy(p, (*i).lk, lksize);
        p += lksize;
    }
    param[0] = n;
    if (n > 0)
       write_link_keys(param);
}

