#ifndef FTCLASSLIBUSBDEVBT_H
#define FTCLASSLIBUSBDEVBT_H


class ftbtdev {//small object for ft BT enumeration
    inquiry_info info;
public:
    ftbtdev(inquiry_info* ii) {
        info = *ii;
    }
    BD_ADDR* BtAddr() {
        return &info.bdaddr;
    }
};

class ftdev {//this should in the future encapsulate the real TXC
    int sock;
    int parseState;
    unsigned short X1_crc, X1_len, X1_pos;
    unsigned char *X1_pkt;
    unsigned short chksum();
    void parse(const unsigned char *, unsigned);
public:
    ftdev(): sock(0) { parseState = 0;}
    int Open(BD_ADDR *bt_addr, int chan=1, SocketCallback cb=&ftdev::recv) {
        L2CAPAddr s;
        s.bdaddr = *bt_addr;
        s.psm = chan;//abuse the psm for the channelID
        sock = Socket_Open(SOCKET_RFCOM, &s.hdr, cb, this);//Open the serial connection via RFCOMM
        if (sock<=0)
           printf("Opening of RFCOMM socket for ftdevice failed (%d)\n", sock);
        return sock;
    }
    static void recv(int socket, SocketState state, const u8* data, int len, void* userData) {
        if (userData) ((ftdev*)userData)->receive(socket, state, data, len);
    }
    void receive(int socket, SocketState state, const u8* data, int len);// {printf("ftdev::receive was called: socket %d, state=%d, length=%d\n", socket, state, len);}
};

extern ftdev _ftdev;

unsigned InitFtBtDeviceList();
int GetNrOfFtBtDevices();
ftbtdev* GetFtUsbDeviceHandle(unsigned  Num);
unsigned OpenFtBtDevice(ftbtdev* d);

#endif
